/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.jfr.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IOptionDescriptor;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.flightrecorder.configuration.OptionInfo;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeInfo;
import org.openjdk.jmc.flightrecorder.configuration.internal.CommonConstraints;
import org.openjdk.jmc.flightrecorder.configuration.internal.EventTypeIDV2;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.FlightRecorderServiceV2;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.Messages;

public final class EventTypeMetadataV2
implements IEventTypeInfo {
    private static final String JFR_SETTINGS_PERIOD = "jdk.settings.Period";
    private final Long id;
    private final EventTypeIDV2 eventTypeID;
    private final String label;
    private final String description;
    private final String[] category;
    private final Map<String, OptionInfo<?>> optionInfoByKey;

    private static OptionInfo<?> optionInfoFrom(CompositeData data) {
        String label = (String)data.get("label");
        String description = (String)data.get("description");
        String contentType = (String)data.get("contentType");
        String defaultValue = (String)data.get("defaultValue");
        String jfrPkg = "jdk.jfr.";
        String jfrPeriod = "jdk.jfr.Period";
        String jfrFlag = "jdk.jfr.Flag";
        if (contentType == null) {
            String typeName = (String)data.get("typeName");
            if (JFR_SETTINGS_PERIOD.equals(typeName)) {
                contentType = "jdk.jfr.Period";
            }
            if (contentType != null) {
                FlightRecorderServiceV2.LOGGER.fine("Inferred content type '" + contentType + "' for option " + label);
            }
        }
        if (contentType == null) {
            String key = (String)data.get("name");
            if ("period".equals(key)) {
                contentType = "jdk.jfr.Period";
            } else if ("true".equals(defaultValue) || "false".equals(defaultValue)) {
                contentType = "jdk.jfr.Flag";
            }
            if (contentType != null) {
                FlightRecorderServiceV2.LOGGER.warning("Inferred content type '" + contentType + "' for option " + label);
            }
        }
        IConstraint constraint = CommonConstraints.forContentTypeV2((String)contentType, (String)defaultValue);
        return EventTypeMetadataV2.optionInfoFrom(label, description, constraint, contentType, defaultValue);
    }

    private static <T> OptionInfo<T> optionInfoFrom(String label, String description, IConstraint<T> constraint, String jdkContentType, String defaultPersistedValue) {
        Object defaultValue;
        try {
            defaultValue = constraint.parsePersisted(defaultPersistedValue);
        }
        catch (QuantityConversionException e) {
            RJMXCorePlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
            String strDef = Messages.getString("EventTypeMetadataV2_BAD_DEFAULT_VALUE");
            defaultValue = strDef;
        }
        return new OptionInfo(label, description, constraint, defaultValue);
    }

    static EventTypeMetadataV2 from(CompositeData data) {
        Long id = (Long)data.get("id");
        String name = (String)data.get("name");
        String label = (String)data.get("label");
        String description = (String)data.get("description");
        String[] category = (String[])data.get("categoryNames");
        CompositeData[] settings = (CompositeData[])data.get("settingDescriptors");
        EventTypeIDV2 eventTypeID = new EventTypeIDV2(name);
        HashMap infoMap = new HashMap(settings.length);
        for (CompositeData setting : settings) {
            String key = (String)setting.get("name");
            OptionInfo<?> info = EventTypeMetadataV2.optionInfoFrom(setting);
            infoMap.put(key, info);
        }
        return new EventTypeMetadataV2(id, eventTypeID, label, description, category, infoMap);
    }

    EventTypeMetadataV2(Long id, EventTypeIDV2 eventTypeID, String label, String description, String[] category, Map<String, OptionInfo<?>> optionInfoMap) {
        this.id = id;
        this.eventTypeID = eventTypeID;
        this.label = label;
        this.description = description;
        this.category = category;
        this.optionInfoByKey = Collections.unmodifiableMap(optionInfoMap);
    }

    public Long getId() {
        return this.id;
    }

    public String[] getHierarchicalCategory() {
        return this.category;
    }

    public EventTypeIDV2 getEventTypeID() {
        return this.eventTypeID;
    }

    public String getName() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, OptionInfo<?>> getOptionDescriptors() {
        return this.optionInfoByKey;
    }

    public IOptionDescriptor<?> getOptionInfo(String optionKey) {
        return (IOptionDescriptor)this.optionInfoByKey.get(optionKey);
    }

    public String toString() {
        return "EventTypeMetadataV2 [type=" + String.valueOf(this.eventTypeID) + ", id=" + this.id + ", category=" + String.join((CharSequence)" / ", this.category) + ", label=" + this.label + ", options=" + String.valueOf(this.optionInfoByKey.keySet()) + "]";
    }
}

