/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.labelingrules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openjdk.jmc.common.jvm.JVMCommandLineToolkit;
import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.common.labelingrules.NamingRule;
import org.openjdk.jmc.common.messages.internal.Messages;
import org.openjdk.jmc.common.resource.Resource;
import org.openjdk.jmc.common.util.Environment;

public class NameConverter {
    private static final Comparator<NamingRule> COMPARATOR = new Comparator<NamingRule>(){

        @Override
        public int compare(NamingRule o1, NamingRule o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };
    private static final NameConverter INSTANCE = new NameConverter();
    protected List<NamingRule> rules = new ArrayList<NamingRule>();
    private String identity;

    public static NameConverter getInstance() {
        return INSTANCE;
    }

    public NameConverter() {
        this(new ArrayList<NamingRule>());
    }

    public NameConverter(List<NamingRule> rules) {
        this.rules = rules;
    }

    public String format(JVMDescriptor descriptor) {
        Object[] values = this.prepareValues(descriptor);
        NamingRule rule = this.getMatchingRule(values);
        if (rule != null) {
            return rule.format(values);
        }
        return MessageFormat.format(Messages.getString("NameConverter_LOCAL_NAME_TEMPLATE"), descriptor);
    }

    public Resource getImageResource(JVMDescriptor descriptor) {
        NamingRule rule = this.getMatchingRule(this.prepareValues(descriptor));
        return rule == null ? null : rule.getImageResource();
    }

    public void addNamingRule(NamingRule rule) {
        this.rules.add(rule);
        this.rules.sort(COMPARATOR);
    }

    public List<NamingRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    private NamingRule getMatchingRule(Object[] values) {
        for (NamingRule rule : this.rules) {
            try {
                if (!rule.matches(values)) continue;
                return rule;
            }
            catch (RuntimeException runtimeException) {
            }
        }
        return null;
    }

    public void setRules(List<NamingRule> rules) {
        this.rules = rules;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    private Object[] prepareValues(JVMDescriptor descriptor) {
        return new Object[]{descriptor.getJavaVersion(), descriptor.getJvmType(), descriptor.getJvmArch(), this.getValidName(descriptor), descriptor.getJavaCommand(), descriptor.getPid() != null ? String.valueOf(descriptor.getPid()) : "", descriptor.isDebug(), descriptor.getJVMArguments()};
    }

    private String getValidName(JVMDescriptor descriptor) {
        Integer pid = descriptor.getPid();
        if (this.identity != null && pid != null && pid == Environment.getThisPID() && descriptor.isAttachable().booleanValue()) {
            return this.identity + ".this";
        }
        String name = JVMCommandLineToolkit.getMainClassOrJar(descriptor.getJavaCommand());
        if (name != null && name.length() > 0) {
            return name;
        }
        return Messages.getString("NameConverter_UNKNOWN_LOCAL_JVM");
    }

    static enum ValueArrayInfo {
        JAVAVERSION(0, "JDK", "{0}"),
        JVMTYPE(1, "JVMType", "{1}"),
        JVMARCH(2, "JVMArch", "{2}"),
        NAME(3, "Name", "{3}"),
        JAVACOMMAND(4, "JavaCmd", "{4}"),
        PID(5, "PID", "{5}"),
        DEBUG(6, "IsDebug", "{6}"),
        JVMARGS(7, "JVMArgs", "{7}");

        private int index;
        private String valueName;
        private String matchExpression;

        private ValueArrayInfo(int index, String valueName, String matchExpression) {
            this.index = index;
            this.valueName = valueName;
            this.matchExpression = matchExpression;
        }

        public int getIndex() {
            return this.index;
        }

        public String getValueName() {
            return this.valueName;
        }

        public String getMatchExpression() {
            return this.matchExpression;
        }
    }
}

