/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import org.openjdk.jmc.common.unit.ScaleFactor;

public class ImpreciseScaleFactor
extends ScaleFactor {
    private final double numberFactor;

    public ImpreciseScaleFactor(double factor) {
        this.numberFactor = factor;
    }

    @Override
    public ScaleFactor concat(ScaleFactor innerFactor) {
        if (innerFactor.isUnity()) {
            return this;
        }
        return new ImpreciseScaleFactor(innerFactor.targetValue(this.numberFactor));
    }

    @Override
    public ScaleFactor invert() {
        return new ImpreciseScaleFactor(1.0 / this.numberFactor);
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        if (this.numberFactor >= 1.0) {
            if (srcNumericalValue >= 0L) {
                return (double)srcNumericalValue > (double)maxAbsValue / this.getMultiplier();
            }
            return (double)srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.getMultiplier();
        }
        if (srcNumericalValue >= 0L) {
            return this.targetValue(srcNumericalValue) > maxAbsValue;
        }
        return this.targetValue(srcNumericalValue) < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (this.numberFactor >= 1.0) {
            if (srcNumericalValue >= 0.0) {
                return srcNumericalValue > (double)maxAbsValue / this.getMultiplier();
            }
            return srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.getMultiplier();
        }
        if (srcNumericalValue >= 0.0) {
            return this.targetValue(srcNumericalValue) > (double)maxAbsValue;
        }
        return this.targetValue(srcNumericalValue) < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return srcNumericalValue * this.numberFactor;
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        return Math.round((double)srcNumericalValue * this.numberFactor);
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        return (long)Math.floor((double)srcNumericalValue * this.numberFactor);
    }

    @Override
    public Number targetNumber(long srcNumericalValue) {
        return this.targetValue((double)srcNumericalValue);
    }

    @Override
    public Number targetNumber(Number srcNumericalValue) {
        return this.targetValue(srcNumericalValue.doubleValue());
    }

    @Override
    public boolean isUnity() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ImpreciseScaleFactor && Double.compare(this.numberFactor, ((ImpreciseScaleFactor)other).numberFactor) == 0;
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.numberFactor);
    }

    public String toString() {
        return Double.toString(this.numberFactor);
    }

    @Override
    public double getMultiplier() {
        return this.numberFactor;
    }
}

