/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.io.IOException;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.util.MCType;

public class MethodToolkit {
    private static final String TYPE_VOID = Void.TYPE.getName();
    private static final String TYPE_BOOLEAN = Boolean.TYPE.getName();
    private static final String TYPE_BYTE = Byte.TYPE.getName();
    private static final String TYPE_CHAR = Character.TYPE.getName();
    private static final String TYPE_SHORT = Short.TYPE.getName();
    private static final String TYPE_INTEGER = Integer.TYPE.getName();
    private static final String TYPE_LONG = Long.TYPE.getName();
    private static final String TYPE_FLOAT = Float.TYPE.getName();
    private static final String TYPE_DOUBLE = Double.TYPE.getName();
    private static final String[] PRIMITIVE_TYPES = new String[]{TYPE_BOOLEAN, TYPE_BYTE, TYPE_CHAR, TYPE_SHORT, TYPE_INTEGER, TYPE_LONG, TYPE_FLOAT, TYPE_DOUBLE, TYPE_VOID};

    private MethodToolkit() {
    }

    public static boolean isPrimitive(String typeName) {
        if (typeName != null) {
            for (String element : PRIMITIVE_TYPES) {
                if (!element.equals(typeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static String formatQualifiedName(IMCPackage mcPackage, String className) {
        return MethodToolkit.formatQualifiedName(mcPackage, className, '.');
    }

    private static String formatQualifiedName(IMCPackage mcPackage, String className, char separator) {
        if (mcPackage == null || mcPackage.getName() == null || mcPackage.getName().isEmpty()) {
            return className;
        }
        return mcPackage.getName() + separator + className;
    }

    public static Boolean hasNestedTypes(String className) {
        if (className == null) {
            return false;
        }
        return className.indexOf(36) != -1;
    }

    public static String topLevelType(String className) {
        int index = className.indexOf(36);
        if (index == -1) {
            return className;
        }
        return className.substring(0, index);
    }

    public static String nestedTypes(String className) {
        int index = className.indexOf(36);
        if (index == -1 && index + 1 < className.length()) {
            return null;
        }
        return className.substring(index + 1);
    }

    public static Boolean isArray(String typeName) {
        if (typeName == null) {
            return false;
        }
        return typeName.indexOf(91) > 0;
    }

    public static String refTypeToFieldDescriptor(String refType) {
        return MethodToolkit.isDescOrRefArray(refType) ? refType : "L" + refType + ";";
    }

    public static String binaryNameToCanonical(String binaryName) {
        return binaryName.replace('$', '.');
    }

    public static String refTypeToBinaryJLS(String refType) throws IllegalArgumentException {
        if (refType.length() == 0 || refType.charAt(0) != '[') {
            return refType.replace('/', '.');
        }
        return MethodToolkit.fieldDescToBinaryJLS(refType);
    }

    public static IMCType typeFromReference(String refType) throws IllegalArgumentException {
        return MethodToolkit.typeFromBinaryJLS(MethodToolkit.refTypeToBinaryJLS(refType));
    }

    public static IMCType typeFromBinaryJLS(String jlsType) throws IllegalArgumentException {
        return new MCType(jlsType);
    }

    public static String fieldDescToBinaryJLS(String fieldDesc) throws IllegalArgumentException {
        StringBuilder out = new StringBuilder();
        try {
            MethodToolkit.fieldDescToBinaryJLS(fieldDesc, 0, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Implementation error", e);
        }
        return out.toString();
    }

    public static int fieldDescToBinaryJLS(CharSequence desc, int start, Appendable out) throws IllegalArgumentException, IOException {
        int top = desc.length();
        if (start >= top) {
            throw new IllegalArgumentException("start=" + start + " > in.length()=" + top);
        }
        int pos = start;
        char c = desc.charAt(pos++);
        switch (c) {
            case '[': {
                pos = MethodToolkit.fieldDescToBinaryJLS(desc, pos, out);
                out.append("[]");
                break;
            }
            case 'B': {
                out.append(TYPE_BYTE);
                break;
            }
            case 'C': {
                out.append(TYPE_CHAR);
                break;
            }
            case 'D': {
                out.append(TYPE_DOUBLE);
                break;
            }
            case 'F': {
                out.append(TYPE_FLOAT);
                break;
            }
            case 'I': {
                out.append(TYPE_INTEGER);
                break;
            }
            case 'J': {
                out.append(TYPE_LONG);
                break;
            }
            case 'S': {
                out.append(TYPE_SHORT);
                break;
            }
            case 'Z': {
                out.append(TYPE_BOOLEAN);
                break;
            }
            case 'V': {
                out.append(TYPE_VOID);
                break;
            }
            case 'L': {
                while (pos < top) {
                    if ((c = desc.charAt(pos++)) == ';') {
                        return pos;
                    }
                    out.append(c == '/' ? (char)'.' : (char)c);
                }
                throw new IllegalArgumentException("Class name '" + desc.subSequence(start + 1, pos) + "' in field descriptor not terminated with ';'.");
            }
            default: {
                throw new IllegalArgumentException("The char '" + c + "' is not a valid first char of a field descriptor.");
            }
        }
        return pos;
    }

    public static boolean isDescOrRefArray(String fieldDesc) {
        return fieldDesc.startsWith("[");
    }

    public static boolean isDescPrimitive(String fieldDesc) {
        return fieldDesc.length() == 1;
    }
}

