/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.libj.net.URLs;
import org.openjax.xml.sax.CachedInputSource;
import org.openjax.xml.sax.FastSAXParser;
import org.openjax.xml.sax.Validator;
import org.openjax.xml.sax.XmlCatalog;
import org.openjax.xml.sax.XmlEntity;
import org.openjax.xml.sax.XmlPreview;
import org.openjax.xml.sax.XmlPreviewHandler;
import org.xml.sax.SAXParseException;

public final class XmlPreviewParser {
    public static XmlPreview parse(URL url) throws IOException, SAXParseException {
        try (CachedInputSource inputSource = new CachedInputSource(null, url.toString(), null, url.openConnection());){
            XmlPreview xmlPreview = XmlPreviewParser.parse(url, inputSource);
            return xmlPreview;
        }
    }

    static XmlPreview parse(URL url, CachedInputSource inputSource) throws IOException, SAXParseException {
        XmlPreviewHandler previewHandler = new XmlPreviewHandler(new XmlCatalog(url, inputSource));
        FastSAXParser.parse(inputSource.getCharacterStream(), previewHandler);
        XmlPreview preview = previewHandler.toXmlPreview();
        XmlPreviewParser.process(previewHandler, url.toString(), true);
        return preview;
    }

    private static HashMap<String, URL> clone(Map<String, URL> map) {
        return map == null ? null : new HashMap<String, URL>(map);
    }

    private static boolean process(XmlPreviewHandler previewHandler, String uri, boolean isImport) throws IOException, SAXParseException {
        boolean hasImports;
        HashMap<String, URL> includes = XmlPreviewParser.clone(previewHandler.getIncludes());
        HashMap<String, URL> imports = XmlPreviewParser.clone(previewHandler.getImports());
        Set<String> visitedURIs = previewHandler.getVisitedURIs();
        boolean bl = hasImports = imports != null && imports.size() > 0;
        if (hasImports) {
            visitedURIs.addAll(imports.keySet());
        }
        if (includes != null && includes.size() > 0) {
            XmlPreviewParser.traverse(previewHandler, includes, false);
        }
        if (isImport) {
            visitedURIs.remove(uri);
            if (visitedURIs.isEmpty()) {
                return false;
            }
        }
        if (hasImports) {
            XmlPreviewParser.traverse(previewHandler, imports, true);
        }
        return true;
    }

    private static void traverse(XmlPreviewHandler previewHandler, Map<String, URL> schemaLocations, boolean isImport) throws IOException, SAXParseException {
        if (schemaLocations.size() > 0) {
            for (Map.Entry<String, URL> entry : schemaLocations.entrySet()) {
                String uri;
                block6: {
                    URL location = entry.getValue();
                    if (!previewHandler.getVisitedURLs().add(location)) continue;
                    uri = entry.getKey();
                    XmlCatalog catalog = previewHandler.getCatalog();
                    if (catalog.getEntity(uri) != null) continue;
                    try {
                        XmlEntity entity;
                        CachedInputSource inputSource = new CachedInputSource(null, location.toString(), previewHandler.getSystemId(), location.openConnection());
                        if (isImport) {
                            XmlCatalog nextCatalog = new XmlCatalog(location, inputSource);
                            previewHandler.reset(nextCatalog);
                            entity = nextCatalog;
                        } else {
                            entity = new XmlEntity(location, inputSource);
                        }
                        FastSAXParser.parse(inputSource.getCharacterStream(), previewHandler);
                        catalog.putEntity(uri, entity);
                    }
                    catch (IOException e) {
                        if (Validator.isRemoteAccessException(e) && !URLs.isLocal((URL)location)) break block6;
                        throw e;
                    }
                }
                if (XmlPreviewParser.process(previewHandler, uri, isImport)) continue;
                break;
            }
        }
    }

    private XmlPreviewParser() {
    }
}

