/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.io.IOException;
import java.net.URL;
import org.libj.util.StringPaths;
import org.libj.util.function.Throwing;
import org.openjax.xml.sax.CachedInputSource;
import org.openjax.xml.sax.XmlCatalog;
import org.openjax.xml.sax.XmlEntity;
import org.openjax.xml.schema.SchemaResolver;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

class XmlCatalogResolver
implements LSResourceResolver {
    private final XmlCatalog catalog;

    static String getPath(String referrer, String location) {
        return StringPaths.isAbsolute((String)location) ? location : StringPaths.newPath((String)StringPaths.getCanonicalParent((String)referrer), (String)location);
    }

    XmlCatalogResolver(XmlCatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (namespaceURI == null && systemId == null) {
            return null;
        }
        if (systemId == null) {
            systemId = namespaceURI;
        } else if (baseURI != null) {
            systemId = XmlCatalogResolver.getPath(baseURI, systemId);
        }
        try {
            XmlEntity entity = this.catalog.getEntity(systemId);
            if (entity == null) {
                if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                    entity = W3C.SCHEMA_XSD.getEntity();
                    this.catalog.putEntity(namespaceURI, entity);
                } else if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                    entity = W3C.XML_XSD.getEntity();
                    this.catalog.putEntity(namespaceURI, entity);
                }
            }
            if (entity == null) {
                try {
                    return new CachedInputSource(publicId, systemId, baseURI, new URL(systemId).openConnection());
                }
                catch (IOException e) {
                    return null;
                }
            }
            CachedInputSource inputSource = entity.getInputSource();
            inputSource.getCharacterStream().close();
            inputSource.setBaseURI(baseURI);
            return inputSource;
        }
        catch (IOException e) {
            Throwing.rethrow((Throwable)e);
            throw new Error("Will never get here");
        }
    }

    static enum W3C {
        SCHEMA_XSD("http://www.w3.org/2001/XMLSchema"),
        XML_XSD("http://www.w3.org/XML/1998/namespace");

        private final String namespaceURI;

        XmlEntity getEntity() throws IOException {
            URL resource = SchemaResolver.resolve((String)this.namespaceURI, null);
            if (resource == null) {
                throw new IllegalStateException("Unable to find resource for namespace=\"" + this.namespaceURI + "\"");
            }
            return new XmlEntity(resource, new CachedInputSource(null, this.namespaceURI, null, resource.openConnection()));
        }

        private W3C(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }
    }
}

