/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openjax.xml.sax.CachedInputSource;
import org.openjax.xml.sax.XmlEntity;

public class XmlCatalog
extends XmlEntity {
    private LinkedHashMap<String, XmlEntity> uriToEntity;

    public XmlCatalog(URL location, CachedInputSource inputSource) {
        super(location, Objects.requireNonNull(inputSource));
    }

    private Map<String, XmlEntity> uriToSystemId() {
        return this.uriToEntity == null ? (this.uriToEntity = new LinkedHashMap()) : this.uriToEntity;
    }

    public XmlEntity putEntity(String uri, XmlEntity entity) {
        return this.uriToSystemId().put(uri, Objects.requireNonNull(entity));
    }

    public XmlEntity getEntity(String uri) throws IOException {
        if (uri.equals(this.location.toString())) {
            return this;
        }
        if (this.uriToEntity == null) {
            return null;
        }
        XmlEntity entity = this.uriToEntity.get(uri);
        if (entity != null) {
            return entity;
        }
        for (XmlEntity catalog : this.uriToEntity.values()) {
            if (!(catalog instanceof XmlCatalog) || catalog == this || (entity = ((XmlCatalog)catalog).getEntity(uri)) == null) continue;
            return entity;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.uriToEntity == null || this.uriToEntity.isEmpty();
    }

    public String toTR9401() {
        StringBuilder builder = new StringBuilder();
        this.toTR9401(new HashSet<String>(), builder);
        return builder.toString();
    }

    private void toTR9401(Set<String> uris, StringBuilder builder) {
        if (this.uriToEntity == null || this.uriToEntity.size() == 0) {
            return;
        }
        int i = 0;
        for (Map.Entry<String, XmlEntity> entry : this.uriToEntity.entrySet()) {
            if (uris.contains(entry.getKey())) continue;
            uris.add(entry.getKey());
            if (i++ > 0) {
                builder.append('\n');
            }
            XmlEntity entity = entry.getValue();
            String line = "\"" + entry.getKey() + "\" \"" + entity.getLocation() + "\"";
            builder.append(entry.getKey().equals(entry.getKey()) ? "PUBLIC " : "SYSTEM ").append(line);
            builder.append("\nREWRITE_SYSTEM ").append(line);
            if (!(entity instanceof XmlCatalog) || entity == this) continue;
            ((XmlCatalog)entity).toTR9401(uris, builder);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.uriToEntity != null) {
            for (XmlEntity entity : this.uriToEntity.values()) {
                if (entity == this) continue;
                entity.close();
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof XmlCatalog) || !super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.uriToEntity, ((XmlCatalog)obj).uriToEntity);
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.uriToEntity != null) {
            hashCode = 31 * hashCode + this.uriToEntity.hashCode();
        }
        return hashCode;
    }
}

