/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class SAXParsers {
    private static final Logger logger = LoggerFactory.getLogger(SAXParsers.class);
    private static final SAXParserFactory[] factory = new SAXParserFactory[2];

    private static SAXParserFactory newFactory(boolean validating) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParserFactory factory;
        block3: {
            try {
                factory = SAXParserFactory.newInstance("org.apache.xerces.jaxp.SAXParserFactoryImpl", null);
            }
            catch (FactoryConfigurationError e) {
                factory = SAXParserFactory.newInstance();
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Unable to create SAXParserFactory of type org.apache.xerces.jaxp.SAXParserFactoryImpl. Factory of " + factory.getClass().getName() + " created instead.", (Throwable)e);
            }
        }
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(true);
        factory.setValidating(validating);
        if (!factory.getFeature("http://xml.org/sax/features/xml-1.1")) {
            throw new FactoryConfigurationError("Expected XML 1.1");
        }
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", validating);
        factory.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        factory.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
        return factory;
    }

    private static SAXParserFactory getFactory(boolean validating) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        int index;
        int n = index = validating ? 0 : 1;
        if (factory[index] == null) {
            SAXParsers.factory[index] = SAXParsers.newFactory(validating);
        }
        return factory[index];
    }

    public static SAXParser newParser(boolean validating) throws SAXException {
        try {
            return SAXParsers.getFactory(validating).newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    private SAXParsers() {
    }
}

