/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.io.IOException;
import java.io.Reader;
import org.libj.lang.ObjectUtil;
import org.openjax.xml.sax.FasterSAXHandler;
import org.xml.sax.SAXParseException;

public final class FastSAXParser {
    private static final int DEFAULT_READ_LIMIT = 8192;

    private static boolean q(boolean inDeclaration, int ch) {
        return ch == 34 || inDeclaration && ch == 39;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parse(Reader in, FasterSAXHandler handler) throws IOException, SAXParseException {
        int ch0;
        int skipToNext = 0;
        boolean inElement = false;
        int startElem = -1;
        int startAttr = -1;
        int startValue = -1;
        boolean inComment = false;
        boolean inQuote = false;
        boolean inDeclaration = false;
        boolean inDoctype = false;
        int prefixLen = 0;
        int attrNameLen = 0;
        in.mark(8192);
        handler.startDocument();
        int row = 1;
        int col = 1;
        int ch1 = 0;
        int ch2 = 0;
        int i = 0;
        while ((ch0 = in.read()) != -1) {
            if (ch0 == 10 || ch0 == 13 && ch1 != 10) {
                col = 1;
                ++row;
            }
            if (skipToNext != 0) {
                if (ch0 == skipToNext) {
                    skipToNext = 0;
                }
            } else if (inComment) {
                if (ch0 == 62 && (ch1 == 93 || ch1 == 45 && ch2 == 45)) {
                    int len;
                    in.reset();
                    if (inDoctype) {
                        in.read();
                        len = i - startElem;
                        if (!handler.doctype(len - 2)) {
                            return;
                        }
                    } else {
                        in.read();
                        in.read();
                        in.read();
                        len = i - startElem;
                        if (!handler.comment(len - 6)) {
                            return;
                        }
                    }
                    in.reset();
                    in.skip(len);
                    inComment = false;
                    inDoctype = false;
                } else if (ch2 == 60 && ch1 == 33 && ch0 == 68) {
                    inDoctype = true;
                }
            } else if (ch1 == 60) {
                if (ch0 == 47) {
                    if (!handler.endElement()) {
                        return;
                    }
                    skipToNext = 62;
                    inElement = false;
                } else if (ch0 == 33) {
                    inElement = false;
                    inComment = true;
                } else if (ch0 == 63) {
                    inDeclaration = true;
                    startElem = i;
                    in.mark(8192);
                }
            } else if (inElement) {
                boolean isWs;
                boolean bl = isWs = !inQuote && Character.isWhitespace(ch0);
                if (ch0 == 58 && !inQuote) {
                    if (startElem != -1) {
                        prefixLen = i - startElem;
                    } else {
                        if (startAttr == -1) throw new SAXParseException("Unable to parse XML", null, ObjectUtil.simpleIdentityString((Object)in), row, col);
                        prefixLen = i - startAttr;
                    }
                } else if (ch0 == 62 || ch0 == 61 || FastSAXParser.q(inDeclaration, ch0) || isWs) {
                    if (startElem != -1) {
                        in.reset();
                        int localName = i - startElem - prefixLen - 1;
                        if (inDeclaration ? !handler.startDeclaration(localName) : !handler.startElement(prefixLen, localName)) {
                            return;
                        }
                        in.reset();
                        in.skip(prefixLen + localName + 1);
                        startElem = -1;
                        prefixLen = 0;
                    } else if (!(startAttr == -1 || startAttr == i - 1 || ch1 == 47 || inDeclaration && ch1 == 63)) {
                        if (attrNameLen == 0) {
                            attrNameLen = i - startAttr - prefixLen - 1;
                        } else if (FastSAXParser.q(inDeclaration, ch0)) {
                            if (!inQuote && startValue == -1) {
                                startValue = i;
                            } else {
                                in.reset();
                                int skip = startValue - startAttr - prefixLen - attrNameLen;
                                int value = i - startValue - 1;
                                if (!handler.attribute(prefixLen, attrNameLen, skip, value)) {
                                    return;
                                }
                                int len = prefixLen + attrNameLen + skip + value;
                                in.reset();
                                in.skip(len + 1);
                                startElem = -1;
                                prefixLen = 0;
                                attrNameLen = 0;
                                startAttr = -1;
                                startValue = -1;
                            }
                        }
                    }
                    if (ch0 == 62) {
                        inElement = false;
                        startAttr = -1;
                        if (inDeclaration) {
                            inDeclaration = false;
                            if (!handler.endDeclaration()) {
                                return;
                            }
                        } else if (!handler.startElement()) {
                            return;
                        }
                        if (ch1 == 47 && !handler.endElement()) {
                            return;
                        }
                    }
                    if (attrNameLen == 0 && isWs) {
                        startAttr = i;
                        in.mark(8192);
                    }
                }
            } else if (ch0 == 60) {
                inElement = true;
                startElem = i;
                in.mark(8192);
            }
            ch2 = ch1;
            ch1 = ch0;
            if (!inComment && FastSAXParser.q(inDeclaration, ch0)) {
                inQuote = !inQuote;
            }
            ++i;
            ++col;
        }
        handler.endDocument();
    }

    private FastSAXParser() {
    }
}

