/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.openjax.xml.sax.FasterSAXHandler;

public abstract class FastSAXHandler
implements FasterSAXHandler {
    protected Reader reader;
    private ArrayList<Element> stack;
    private static final int DEFAULT_BUFFER_SIZE = 64;
    private static final double RESIZE_FACTOR = 1.5;
    private char[] buf = new char[64];
    private boolean inDeclaration;

    public FastSAXHandler(Reader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    protected FastSAXHandler() {
    }

    private String read(Reader in, int len) throws IOException {
        if (len >= this.buf.length) {
            char[] resized = new char[(int)((double)(len + 1) * 1.5)];
            System.arraycopy(this.buf, 0, resized, 0, this.buf.length);
            this.buf = resized;
        }
        in.read(this.buf, 0, len);
        return new String(this.buf, 0, len);
    }

    private String lookupNamespace(String prefix) {
        if (this.stack != null) {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                String namespace;
                Element element = this.stack.get(i);
                if (element.prefixToNamespace == null || (namespace = (String)element.prefixToNamespace.get(prefix)) == null) continue;
                return namespace;
            }
        }
        return null;
    }

    @Override
    public final boolean startDeclaration(int nameLen) throws IOException {
        this.inDeclaration = true;
        return true;
    }

    @Override
    public final boolean endDeclaration() throws IOException {
        this.inDeclaration = false;
        return true;
    }

    @Override
    public final boolean attribute(int prefixLen, int localPartLen, int skip, int valueLen) throws IOException {
        String prefix;
        if (this.inDeclaration) {
            return true;
        }
        if (prefixLen > 0) {
            prefix = this.read(this.reader, prefixLen - 1);
            this.reader.read();
        } else {
            prefix = null;
        }
        String localName = this.read(this.reader, localPartLen);
        this.reader.skip(skip);
        String value = this.read(this.reader, valueLen);
        Element element = this.stack.get(this.stack.size() - 1);
        if (prefixLen == 0 && "xmlns".equals(localName)) {
            element.prefixToNamespace().put("", value);
        } else if ("xmlns".equals(prefix)) {
            element.prefixToNamespace().put(localName, value);
        }
        element.attributes().add(new String[]{prefix != null ? prefix : "", localName, value});
        return true;
    }

    @Override
    public final boolean startElement(int prefixLen, int localPartLen) throws IOException {
        String prefix;
        if (prefixLen > 0) {
            prefix = this.read(this.reader, prefixLen - 1);
            this.reader.read();
        } else {
            prefix = "";
        }
        if (this.stack == null) {
            this.stack = new ArrayList();
        }
        this.stack.add(new Element(prefix, this.read(this.reader, localPartLen)));
        return true;
    }

    @Override
    public final boolean startElement() throws IOException {
        HashMap<QName, String> nameToAttribute;
        Element element = this.stack.get(this.stack.size() - 1);
        if (element.namespace == null) {
            element.namespace = this.lookupNamespace(element.prefix);
        }
        if (element.attributes == null) {
            nameToAttribute = null;
        } else {
            nameToAttribute = new HashMap<QName, String>();
            ArrayList attributes = element.attributes;
            int i$ = attributes.size();
            for (int i = 0; i < i$; ++i) {
                String[] attribute = (String[])attributes.get(i);
                QName key = new QName(this.lookupNamespace(attribute[0]), attribute[1], attribute[0]);
                nameToAttribute.put(key, attribute[2]);
            }
        }
        element.name = new QName(element.namespace, element.localName, element.prefix);
        return this.startElement(element.name, nameToAttribute);
    }

    @Override
    public final boolean endElement() throws IOException {
        return this.endElement(this.stack.remove(this.stack.size() - 1).name);
    }

    public abstract boolean startElement(QName var1, Map<QName, String> var2) throws IOException;

    public boolean endElement(QName name) throws IOException {
        return true;
    }

    public void reset() {
        if (this.stack != null) {
            this.stack.clear();
        }
        this.inDeclaration = false;
    }

    private static final class Element {
        private final String prefix;
        private final String localName;
        private String namespace;
        private QName name;
        private Map<String, String> prefixToNamespace;
        private ArrayList<String[]> attributes;

        private Element(String prefix, String localName) {
            this.prefix = prefix;
            this.localName = localName;
        }

        private Map<String, String> prefixToNamespace() {
            return this.prefixToNamespace == null ? (this.prefixToNamespace = new HashMap<String, String>()) : this.prefixToNamespace;
        }

        private ArrayList<String[]> attributes() {
            return this.attributes == null ? (this.attributes = new ArrayList()) : this.attributes;
        }
    }
}

