/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URLConnection;
import org.libj.io.ReplayReader;
import org.libj.net.URLConnections;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;

public class CachedInputSource
extends InputSource
implements AutoCloseable,
LSInput,
Serializable {
    private String baseURI;
    private boolean certifiedText;

    private static ReplayReader getReader(InputSource inputSource) {
        if (inputSource.getCharacterStream() instanceof ReplayReader) {
            return (ReplayReader)inputSource.getCharacterStream();
        }
        if (inputSource.getCharacterStream() != null) {
            return new ReplayReader(inputSource.getCharacterStream());
        }
        InputStream byteStream = inputSource.getByteStream();
        if (byteStream != null) {
            return new ReplayReader((Reader)new InputStreamReader(byteStream));
        }
        throw new IllegalArgumentException("InputSource has null CharacterStream and ByteStream");
    }

    public CachedInputSource(String publicId, String systemId, String baseURI, URLConnection connection) throws IOException {
        this(publicId, systemId, baseURI);
        this.setByteStream(URLConnections.checkFollowRedirect((URLConnection)connection).getInputStream());
    }

    public CachedInputSource(String publicId, String systemId, String baseURI, Reader reader) {
        this(publicId, systemId, baseURI);
        this.setCharacterStream((Reader)(reader instanceof CachedReader ? reader : new CachedReader(reader)));
    }

    private CachedInputSource(String publicId, String systemId, String baseURI) {
        this.setPublicId(publicId);
        this.setSystemId(systemId);
        this.setBaseURI(baseURI);
    }

    public CachedInputSource(InputSource inputSource) {
        this(inputSource.getPublicId(), inputSource.getSystemId(), null);
        this.setCharacterStream((Reader)CachedInputSource.getReader(inputSource));
    }

    @Override
    public void setByteStream(InputStream byteStream) {
        super.setCharacterStream((Reader)((Object)new CachedReader(new InputStreamReader(byteStream))));
    }

    @Override
    public String getStringData() {
        return null;
    }

    @Override
    public void setStringData(String stringData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public boolean getCertifiedText() {
        return this.certifiedText;
    }

    @Override
    public void setCertifiedText(boolean certifiedText) {
        this.certifiedText = certifiedText;
    }

    @Override
    public void close() throws IOException {
        ((CachedReader)((Object)this.getCharacterStream())).destroy();
    }

    private static final class CachedReader
    extends ReplayReader {
        private CachedReader(Reader in) {
            super(in);
        }

        public void close() {
            this.buffer.reset(0);
        }

        public void destroy() throws IOException {
            super.close();
        }
    }
}

