/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.jaxb.xjc;

import com.sun.istack.tools.MaskingClassLoader;
import com.sun.tools.xjc.XJCFacade;
import japa.parser.ast.Node;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.jvnet.annox.parser.XAnnotationParser;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.annotate.AnnotatePlugin;
import org.libj.exec.Processes;
import org.libj.net.URIs;
import org.libj.net.URLs;
import org.libj.util.ClassLoaders;
import org.libj.util.CollectionUtil;
import org.libj.util.function.Throwing;
import org.openjax.xml.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XJCompiler {
    private static final Logger logger = LoggerFactory.getLogger(XJCompiler.class);
    private static final boolean embedded = false;

    private XJCompiler() {
    }

    public static void compile(Command command) throws IOException, JAXBException {
        block44: {
            File file;
            LinkedHashSet<URI> schemas = command.getSchemas();
            if (schemas == null || schemas.size() == 0) {
                return;
            }
            ArrayList<String> args = new ArrayList<String>();
            LinkedHashSet classpath = command.classpath;
            if (classpath.size() > 0) {
                args.add("-cp");
                StringBuilder cp = new StringBuilder();
                for (Iterator path : classpath) {
                    cp.append(File.pathSeparator).append(((File)((Object)path)).getAbsolutePath());
                }
                args.add(cp.substring(1));
            }
            args.add(XJCFacade.class.getName());
            args.add("-Xannotate");
            if (command.getDebug()) {
                args.add("-debug");
            }
            if (command.getReadOnly()) {
                args.add("-readOnly");
            }
            if (command.getNoHeader()) {
                args.add("-no-header");
            }
            if (command.getExplicitAnnotation()) {
                args.add("-XexplicitAnnotation");
            }
            if (command.getDisableXmlSecurity()) {
                args.add("-disableXmlSecurity");
            }
            if (command.getContentForWildcard()) {
                args.add("-contentForWildcard");
            }
            if (command.getAutoNameResolution()) {
                args.add("-XautoNameResolution");
            }
            if (command.getTestClassNameAllocator()) {
                args.add("-Xtest-class-name-allocator");
            }
            if (command.getHttpProxyFile() != null) {
                args.add("-httpproxyfile");
                args.add(command.getHttpProxyFile().getAbsolutePath());
            }
            if (command.getHttpProxy() != null) {
                args.add("-httpproxy");
                args.add(command.getHttpProxy());
            }
            if (command.getAddGeneratedAnnotation()) {
                args.add("-mark-generated");
            }
            if (command.getCatalog() != null) {
                System.setProperty("xml.catalog.ignoreMissing", "true");
                args.add("-catalog");
                args.add(command.getCatalog().toURI().toString());
            }
            if (command.getEnableIntrospection()) {
                args.add("-enableIntrospection");
            }
            if (command.getExtension()) {
                args.add("-extension");
            }
            if (command.getLaxSchemaValidation()) {
                args.add("-nv");
            }
            if (command.getNoGeneratedHeaderComments()) {
                args.add("-no-header");
            }
            if (command.getNoPackageLevelAnnotations()) {
                args.add("-npa");
            }
            if (command.getQuiet()) {
                args.add("-quiet");
            }
            if (command.getTargetVersion() != null) {
                args.add("-target");
                args.add(command.getTargetVersion().version);
            }
            if (command.getVerbose()) {
                args.add("-verbose");
            }
            if (command.getSourceType() != null) {
                args.add("-" + command.getSourceType().type);
            }
            if (command.getEncoding() != null) {
                args.add("-encoding");
                args.add(command.getEncoding());
            }
            if (command.getPackageName() != null) {
                args.add("-p");
                args.add(command.getPackageName());
            }
            if (command.getDestDir() != null) {
                args.add("-d");
                args.add(command.getDestDir().getAbsolutePath());
                if (!command.getDestDir().exists() && !command.getDestDir().mkdirs()) {
                    throw new JAXBException("Unable to create output directory " + command.getDestDir().getAbsolutePath());
                }
            }
            ArrayList<File> tempFiles = new ArrayList<File>();
            try {
                URL xsd11to10 = Thread.currentThread().getContextClassLoader().getResource("xsd-1.1-to-1.0.xsl");
                for (URI schema : schemas) {
                    file = File.createTempFile(URIs.getName((URI)schema), "");
                    args.add(file.getAbsolutePath());
                    tempFiles.add(file);
                    Transformer.transform((URL)xsd11to10, (URL)schema.toURL(), (File)file);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
            LinkedHashSet<URI> xjbs = command.getXJBs();
            if (xjbs != null && xjbs.size() > 0) {
                for (URI xjb : xjbs) {
                    args.add("-b");
                    if (URIs.isLocalFile((URI)xjb)) {
                        args.add(xjb.getPath());
                        continue;
                    }
                    file = File.createTempFile(URIs.getName((URI)xjb), "");
                    args.add(file.getAbsolutePath());
                    tempFiles.add(file);
                    Files.write(file.toPath(), URLs.readBytes((URL)xjb.toURL()), new OpenOption[0]);
                }
            }
            if (command.getGenerateEpisode()) {
                File metaInfDir = new File(command.getDestDir(), "META-INF" + File.separator + "sun-jaxb.episode");
                if (!metaInfDir.getParentFile().mkdirs()) {
                    throw new JAXBException("Unable to create output directory: " + metaInfDir.getParentFile().getAbsolutePath());
                }
                args.add("-episode");
                args.add(metaInfDir.getAbsolutePath());
            }
            FilterOutputStream out = new FilterOutputStream(System.out){
                final StringBuilder buffer = new StringBuilder();

                @Override
                public void write(int b) throws IOException {
                    if (b == 10) {
                        this.flush();
                    } else {
                        this.buffer.append((char)b);
                    }
                }

                @Override
                public void flush() throws IOException {
                    super.flush();
                    if (this.buffer.length() == 0) {
                        return;
                    }
                    String line = this.buffer.toString();
                    this.buffer.setLength(0);
                    if (line.startsWith("[ERROR] ")) {
                        if (logger.isErrorEnabled()) {
                            logger.error(line.substring(8));
                        } else if (line.startsWith("[WARNING] ")) {
                            if (logger.isWarnEnabled()) {
                                logger.warn(line.substring(10));
                            } else if (logger.isInfoEnabled()) {
                                logger.info(line);
                            }
                        }
                    }
                }
            };
            MySecurityManager securityManager = new MySecurityManager(System.getSecurityManager());
            try {
                XJCompiler.addJavaArgs(args, false);
                int exitCode = Processes.forkSync(null, (OutputStream)out, (OutputStream)out, (boolean)true, null, null, (String[])args.toArray(new String[args.size()]));
                if (exitCode != 0) {
                    throw new JAXBException("xjc finished with code: " + exitCode + "\n" + CollectionUtil.toString(args, (String)" "));
                }
                if (command.getSuppressWarnings()) {
                    Files.walk(command.getDestDir().toPath(), new FileVisitOption[0]).filter(p -> p.getFileName().toString().endsWith(".java")).map(Path::toFile).forEach(Throwing.rethrow(XJCompiler::insertSuppressWarnings));
                }
                int i$ = tempFiles.size();
                for (int i = 0; i < i$; ++i) {
                    ((File)tempFiles.get(i)).delete();
                }
            }
            catch (IOException | JAXBException e) {
                throw e;
            }
            catch (Throwable t) {
                if (!(t instanceof ExitPolicyException)) {
                    throw new JAXBException(t.getMessage(), t);
                }
                securityManager.disable();
                if (((ExitPolicyException)t).exitCode == 0) break block44;
                throw new JAXBException(CollectionUtil.toString(args, (String)" "));
            }
        }
    }

    private static void insertSuppressWarnings(File file) throws IOException {
        String insert = "@" + SuppressWarnings.class.getName() + "(\"all\")\n";
        String find1 = "public class";
        String find2 = "public abstract class";
        byte[] b1 = insert.getBytes();
        byte[] b2 = new byte[b1.length];
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            String line;
            while ((line = raf.readLine()) != null) {
                if (line.regionMatches(0, insert, 0, insert.length() - 1)) {
                    return;
                }
                if (!line.startsWith("public class") && !line.startsWith("public abstract class")) continue;
                int l1 = b1.length;
                long p = raf.getFilePointer() - (long)line.length() - 1L;
                raf.seek(p);
                while (true) {
                    int l2 = raf.read(b2);
                    raf.seek(p);
                    if (l1 == -1) {
                        return;
                    }
                    raf.write(b1, 0, l1);
                    if (l1 < b1.length) {
                        return;
                    }
                    p = raf.getFilePointer();
                    l1 = raf.read(b1);
                    raf.seek(p);
                    if (l2 == -1) {
                        return;
                    }
                    raf.write(b2, 0, l2);
                    if (l2 < b2.length) {
                        return;
                    }
                    p = raf.getFilePointer();
                }
            }
        }
    }

    private static ArrayList<String> addJavaArgs(ArrayList<String> args, boolean addClassPath) {
        args.add(0, "-Dcom.sun.tools.xjc.XJCFacade.nohack=true");
        args.add(1, "-Dcom.sun.tools.xjc.Options.findServices=true");
        if (addClassPath) {
            args.add(0, "-cp");
            args.add(1, System.getProperty("java.class.path"));
            args.add(2, XJCFacade.class.getName());
        }
        args.add(0, "java");
        return args;
    }

    private static final class MySecurityManager
    extends SecurityManager {
        private final SecurityManager securityManager;
        private boolean enabled = true;

        private MySecurityManager(SecurityManager securityManager) {
            this.securityManager = securityManager;
        }

        public void disable() {
            this.enabled = false;
        }

        @Override
        public void checkPermission(Permission permission) {
            if (this.enabled && permission.getName().startsWith("exitVM")) {
                throw new ExitPolicyException(Integer.parseInt(permission.getName().substring(permission.getName().indexOf(46) + 1)));
            }
            if (this.securityManager != null) {
                this.securityManager.checkPermission(permission);
            }
        }
    }

    private static final class ExitPolicyException
    extends SecurityException {
        private final int exitCode;

        private ExitPolicyException(int exitCode) {
            this.exitCode = exitCode;
        }
    }

    public static class Command {
        private boolean debug;
        private boolean suppressWarnings = true;
        private boolean readOnly;
        private boolean noHeader;
        private boolean explicitAnnotation;
        private boolean disableXmlSecurity;
        private boolean contentForWildcard;
        private boolean autoNameResolution;
        private boolean testClassNameAllocator;
        private String javaModule;
        private File httpProxyFile;
        private String httpProxy;
        private boolean addGeneratedAnnotation;
        private File catalog;
        private boolean overwrite = true;
        private boolean enableIntrospection = true;
        private String encoding;
        private boolean extension;
        private boolean generateEpisode;
        private boolean laxSchemaValidation;
        private boolean noGeneratedHeaderComments;
        private boolean noPackageLevelAnnotations;
        private File destDir;
        private String packageName;
        private boolean quiet;
        private LinkedHashSet<URI> schemas;
        private SourceType sourceType;
        private TargetVersion targetVersion;
        private boolean verbose;
        private LinkedHashSet<URI> xjbs;
        private final LinkedHashSet<File> classpath = new LinkedHashSet();
        private static final Class<?>[] classes = new Class[]{MaskingClassLoader.class, JAXBContext.class, AnnotatePlugin.class, AbstractParameterizablePlugin.class, LogFactory.class, XAnnotationParser.class, Node.class, DataSource.class, StringUtils.class};

        public Command() {
            try {
                for (Class<?> cls : classes) {
                    if (cls.getProtectionDomain().getCodeSource() == null) continue;
                    this.classpath.add(new File(cls.getProtectionDomain().getCodeSource().getLocation().toURI()));
                }
                Collections.addAll(this.classpath, ClassLoaders.getClassPath());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean getDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean getSuppressWarnings() {
            return this.suppressWarnings;
        }

        public void setSuppressWarnings(boolean suppressWarnings) {
            this.suppressWarnings = suppressWarnings;
        }

        public boolean getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public boolean getNoHeader() {
            return this.noHeader;
        }

        public void setNoHeader(boolean noHeader) {
            this.noHeader = noHeader;
        }

        public boolean getExplicitAnnotation() {
            return this.explicitAnnotation;
        }

        public void setExplicitAnnotation(boolean explicitAnnotation) {
            this.explicitAnnotation = explicitAnnotation;
        }

        public boolean getDisableXmlSecurity() {
            return this.disableXmlSecurity;
        }

        public void setDisableXmlSecurity(boolean disableXmlSecurity) {
            this.disableXmlSecurity = disableXmlSecurity;
        }

        public boolean getContentForWildcard() {
            return this.contentForWildcard;
        }

        public void setContentForWildcard(boolean contentForWildcard) {
            this.contentForWildcard = contentForWildcard;
        }

        public boolean getAutoNameResolution() {
            return this.autoNameResolution;
        }

        public void setAutoNameResolution(boolean autoNameResolution) {
            this.autoNameResolution = autoNameResolution;
        }

        public boolean getTestClassNameAllocator() {
            return this.testClassNameAllocator;
        }

        public void setTestClassNameAllocator(boolean testClassNameAllocator) {
            this.testClassNameAllocator = testClassNameAllocator;
        }

        public String getJavaModule() {
            return this.javaModule;
        }

        public void setJavaModule(String javaModule) {
            this.javaModule = javaModule;
        }

        public File getHttpProxyFile() {
            return this.httpProxyFile;
        }

        public void setHttpProxyFile(File httpProxyFile) {
            this.httpProxyFile = httpProxyFile;
        }

        public String getHttpProxy() {
            return this.httpProxy;
        }

        public void setHttpProxy(String httpProxy) {
            this.httpProxy = httpProxy;
        }

        public boolean getAddGeneratedAnnotation() {
            return this.addGeneratedAnnotation;
        }

        public void setAddGeneratedAnnotation(boolean addGeneratedAnnotation) {
            this.addGeneratedAnnotation = addGeneratedAnnotation;
        }

        public File getCatalog() {
            return this.catalog;
        }

        public void setCatalog(File catalog) {
            this.catalog = catalog;
        }

        public boolean getOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public boolean getEnableIntrospection() {
            return this.enableIntrospection;
        }

        public void setEnableIntrospection(boolean enableIntrospection) {
            this.enableIntrospection = enableIntrospection;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public boolean getExtension() {
            return this.extension;
        }

        public void setExtension(boolean extension) {
            this.extension = extension;
        }

        public boolean getGenerateEpisode() {
            return this.generateEpisode;
        }

        public void setGenerateEpisode(boolean generateEpisode) {
            this.generateEpisode = generateEpisode;
        }

        public boolean getLaxSchemaValidation() {
            return this.laxSchemaValidation;
        }

        public void setLaxSchemaValidation(boolean laxSchemaValidation) {
            this.laxSchemaValidation = laxSchemaValidation;
        }

        public boolean getNoGeneratedHeaderComments() {
            return this.noGeneratedHeaderComments;
        }

        public void setNoGeneratedHeaderComments(boolean noGeneratedHeaderComments) {
            this.noGeneratedHeaderComments = noGeneratedHeaderComments;
        }

        public boolean getNoPackageLevelAnnotations() {
            return this.noPackageLevelAnnotations;
        }

        public void setNoPackageLevelAnnotations(boolean noPackageLevelAnnotations) {
            this.noPackageLevelAnnotations = noPackageLevelAnnotations;
        }

        public File getDestDir() {
            return this.destDir;
        }

        public void setDestDir(File destDir) {
            this.destDir = destDir;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public boolean getQuiet() {
            return this.quiet;
        }

        public void setQuiet(boolean quiet) {
            this.quiet = quiet;
        }

        public LinkedHashSet<URI> getSchemas() {
            return this.schemas;
        }

        public void setSchemas(LinkedHashSet<URI> schemas) {
            this.schemas = schemas;
        }

        public SourceType getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(SourceType sourceType) {
            this.sourceType = sourceType;
        }

        public TargetVersion getTargetVersion() {
            return this.targetVersion;
        }

        public void setTargetVersion(TargetVersion targetVersion) {
            this.targetVersion = targetVersion;
        }

        public boolean getVerbose() {
            return this.verbose;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public LinkedHashSet<URI> getXJBs() {
            return this.xjbs;
        }

        public void setXJBs(LinkedHashSet<URI> xjbs) {
            this.xjbs = xjbs;
        }

        public LinkedHashSet<File> getClasspath() {
            return this.classpath;
        }

        public void addClasspath(File path) {
            this.classpath.add(path);
        }

        public void addClasspath(File ... paths) {
            Collections.addAll(this.classpath, paths);
        }

        public static enum TargetVersion {
            _2_0("2.0"),
            _2_1("2.1");

            private final String version;

            private TargetVersion(String type) {
                this.version = type;
            }

            public static TargetVersion fromString(String version) {
                return TargetVersion.valueOf("_" + version.replace('.', '_'));
            }
        }

        public static enum SourceType {
            DTD("dtd"),
            WSDL("wsdl"),
            XMLSCHEMA("xmlschema");

            private final String type;

            private SourceType(String type) {
                this.type = type;
            }

            public static SourceType fromString(String sourceType) {
                return SourceType.valueOf(sourceType.toUpperCase());
            }
        }
    }
}

