/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.jaxb.xjc;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.openjax.xml.sax.LoggingErrorHandler;
import org.openjax.xml.sax.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class JaxbUtil {
    private static final String DEFAULT = "##default";

    public static <T> String toXmlString(T binding) throws JAXBException {
        XmlSchema xmlSchema;
        String localName;
        StringWriter stringWriter = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{binding.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        XmlRootElement xmlRootElement = binding.getClass().getAnnotation(XmlRootElement.class);
        if (xmlRootElement != null) {
            marshaller.marshal(binding, (Writer)stringWriter);
            return stringWriter.toString();
        }
        XmlType xmlType = binding.getClass().getAnnotation(XmlType.class);
        String string = localName = DEFAULT.equals(xmlType.name()) ? binding.getClass().getSimpleName() : xmlType.name();
        String namespace = DEFAULT.equals(xmlType.namespace()) ? ((xmlSchema = binding.getClass().getPackage().getAnnotation(XmlSchema.class)) != null ? xmlSchema.namespace() : DEFAULT) : xmlType.namespace();
        QName qName = new QName(namespace, localName);
        JAXBElement element = new JAXBElement(qName, binding.getClass(), binding);
        marshaller.marshal((Object)element, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static <T> T parse(Class<T> cls, URL url) throws IOException, UnmarshalException {
        return JaxbUtil.parse(cls, Thread.currentThread().getContextClassLoader(), url, (ErrorHandler)new LoggingErrorHandler(), true);
    }

    public static <T> T parse(Class<T> cls, ClassLoader classLoader, URL url) throws IOException, UnmarshalException {
        return JaxbUtil.parse(cls, classLoader, url, (ErrorHandler)new LoggingErrorHandler(), true);
    }

    public static <T> T parse(Class<T> cls, URL url, boolean validate) throws IOException, UnmarshalException {
        return JaxbUtil.parse(cls, Thread.currentThread().getContextClassLoader(), url, (ErrorHandler)new LoggingErrorHandler(), validate);
    }

    public static <T> T parse(Class<T> cls, ClassLoader classLoader, URL url, boolean validate) throws IOException, UnmarshalException {
        return JaxbUtil.parse(cls, classLoader, url, (ErrorHandler)new LoggingErrorHandler(), validate);
    }

    public static <T> T parse(Class<T> cls, URL url, ErrorHandler errorHandler, boolean validate) throws IOException, UnmarshalException {
        return JaxbUtil.parse(cls, Thread.currentThread().getContextClassLoader(), url, errorHandler, validate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parse(Class<T> cls, ClassLoader classLoader, URL url, ErrorHandler errorHandler, boolean validate) throws IOException, UnmarshalException {
        if (validate) {
            try {
                Validator.validate((URL)url, (ErrorHandler)errorHandler);
            }
            catch (SAXException e) {
                throw new UnmarshalException((Throwable)e);
            }
        }
        try (InputStream in = url.openStream();){
            Unmarshaller unmarshaller = JAXBContext.newInstance((String)cls.getPackage().getName(), (ClassLoader)classLoader).createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal(XMLInputFactory.newInstance().createXMLStreamReader(in), cls);
            Object object = element.getValue();
            return (T)object;
        }
        catch (UnmarshalException e) {
            throw e;
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private JaxbUtil() {
    }
}

