/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.jaxb;

import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.openjax.jaxb.xjc.XJCompiler;
import org.openjax.maven.mojo.FilterParameter;
import org.openjax.maven.mojo.FilterType;
import org.openjax.maven.mojo.GeneratorMojo;
import org.openjax.maven.mojo.MojoUtil;
import org.openjax.xml.sax.XmlPreviewParser;

@Mojo(name="xjc", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(goal="xjc")
public class JaxbMojo
extends GeneratorMojo {
    @Parameter(property="debug")
    private boolean debug = false;
    @Parameter(property="readOnly")
    private boolean readOnly = false;
    @Parameter(property="noHeader")
    private boolean noHeader = false;
    @Parameter(property="explicitAnnotation")
    private boolean explicitAnnotation = false;
    @Parameter(property="disableXmlSecurity")
    private boolean disableXmlSecurity = false;
    @Parameter(property="contentForWildcard")
    private boolean contentForWildcard = false;
    @Parameter(property="autoNameResolution")
    private boolean autoNameResolution = false;
    @Parameter(property="testClassNameAllocator")
    private boolean testClassNameAllocator = false;
    @Parameter(property="javaModule")
    private String javaModule;
    @Parameter(property="httpProxyFile")
    private File httpProxyFile;
    @Parameter(property="httpProxy")
    private String httpProxy;
    @Parameter(property="addGeneratedAnnotation")
    private boolean addGeneratedAnnotation = false;
    @Parameter(property="catalog")
    private File catalog;
    @Parameter(property="enableIntrospection")
    private boolean enableIntrospection = true;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="extension")
    private boolean extension = false;
    @Parameter(property="generateEpisode")
    private boolean generateEpisode = false;
    @Parameter(property="laxSchemaValidation")
    private boolean laxSchemaValidation = false;
    @Parameter(property="noGeneratedHeaderComments")
    private boolean noGeneratedHeaderComments = false;
    @Parameter(property="noPackageLevelAnnotations")
    private boolean noPackageLevelAnnotations = false;
    @Parameter(property="packageName")
    private String packageName;
    @Parameter(property="quiet")
    private boolean quiet = false;
    @Parameter(property="sourceType")
    private String sourceType = "xmlschema";
    @Parameter(property="target")
    private String targetVersion;
    @Parameter(property="verbose")
    private boolean verbose = false;
    @FilterParameter(value=FilterType.URL)
    @Parameter(property="schemas", required=true)
    private List<String> schemas;
    @FilterParameter(value=FilterType.URL)
    @Parameter(property="bindings")
    private List<String> bindings;
    private static final ArtifactHandler artifactHandler = new DefaultArtifactHandler("jar");

    public void execute(GeneratorMojo.Configuration configuration) throws MojoExecutionException, MojoFailureException {
        File masterCatalog = null;
        XJCompiler.Command command = new XJCompiler.Command();
        try {
            command.setDebug(this.debug);
            command.setReadOnly(this.readOnly);
            command.setNoHeader(this.noHeader);
            command.setExplicitAnnotation(this.explicitAnnotation);
            command.setDisableXmlSecurity(this.disableXmlSecurity);
            command.setContentForWildcard(this.contentForWildcard);
            command.setAutoNameResolution(this.autoNameResolution);
            command.setTestClassNameAllocator(this.testClassNameAllocator);
            command.setJavaModule(this.javaModule);
            command.setHttpProxyFile(this.httpProxyFile);
            command.setHttpProxy(this.httpProxy);
            command.setAddGeneratedAnnotation(this.addGeneratedAnnotation);
            command.setEnableIntrospection(this.enableIntrospection);
            command.setExtension(this.extension);
            command.setLaxSchemaValidation(this.laxSchemaValidation);
            command.setNoGeneratedHeaderComments(this.noGeneratedHeaderComments);
            command.setNoPackageLevelAnnotations(this.noPackageLevelAnnotations);
            command.setQuiet(this.quiet);
            if (this.targetVersion != null) {
                command.setTargetVersion(XJCompiler.Command.TargetVersion.fromString((String)this.targetVersion));
            }
            if (this.sourceType != null) {
                command.setSourceType(XJCompiler.Command.SourceType.fromString((String)this.sourceType));
            }
            command.setVerbose(this.verbose);
            command.setEncoding(this.encoding);
            command.setPackageName(this.packageName);
            command.setDestDir(configuration.getDestDir());
            command.setOverwrite(configuration.getOverwrite());
            command.setGenerateEpisode(this.generateEpisode);
            masterCatalog = Files.createTempFile("catalog", ".cat", new FileAttribute[0]).toFile();
            if (this.catalog != null) {
                Files.copy(this.catalog.toPath(), masterCatalog.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
            try (FileWriter out = new FileWriter(masterCatalog);){
                if (this.schemas.size() > 0) {
                    for (String schema : new LinkedHashSet<String>(this.schemas)) {
                        URL url = new URL(schema);
                        uris.add(url.toURI());
                        out.write(XmlPreviewParser.parse((URL)url).getCatalog().toTR9401());
                    }
                }
            }
            command.setCatalog(masterCatalog);
            command.setSchemas(uris);
            if (this.bindings != null && this.bindings.size() > 0) {
                command.setXJBs(new LinkedHashSet<String>(this.bindings).stream().map(URI::create).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
            command.addClasspath(MojoUtil.getExecutionClasspath((MavenProject)this.getProject(), (MojoExecution)this.getExecution(), (PluginDescriptor)((PluginDescriptor)this.getPluginContext().get("pluginDescriptor")), (ArtifactRepository)this.getSession().getLocalRepository(), (ArtifactHandler)artifactHandler));
            XJCompiler.compile((XJCompiler.Command)command);
        }
        catch (JAXBException e) {
            throw new MojoExecutionException(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (!command.getDebug() && masterCatalog != null) {
                masterCatalog.delete();
            }
        }
    }
}

