/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.tracking;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.video.processing.tracking.ObjectTracker;
import org.openimaj.video.tracking.klt.FeatureList;
import org.openimaj.video.tracking.klt.KLTTracker;
import org.openimaj.video.tracking.klt.TrackingContext;

public class BasicObjectTracker
implements ObjectTracker<Rectangle, FImage> {
    private TrackingContext trackingContext = new TrackingContext();
    private FeatureList featureList = null;
    private int featuresFound = -1;
    private KLTTracker tracker = null;
    private double accuracy = 0.5;
    private FImage previousFrame;

    public BasicObjectTracker() {
        this(50, 0.5);
    }

    public BasicObjectTracker(int nFeatures) {
        this(nFeatures, 0.5);
    }

    public BasicObjectTracker(double accuracy) {
        this(50, accuracy);
    }

    public BasicObjectTracker(int nFeatures, double accuracy) {
        this.featureList = new FeatureList(nFeatures);
        this.accuracy = accuracy;
        this.tracker = new KLTTracker(this.trackingContext, this.featureList);
    }

    @Override
    public List<Rectangle> trackObject(FImage img) {
        ArrayList<Rectangle> trackedObjects = new ArrayList<Rectangle>();
        this.tracker.trackFeatures(this.previousFrame, img);
        if ((double)this.featureList.countRemainingFeatures() <= (double)this.featuresFound * this.accuracy) {
            return trackedObjects;
        }
        trackedObjects.add(this.featureList.getBounds());
        this.previousFrame = img;
        return trackedObjects;
    }

    @Override
    public List<Rectangle> initialiseTracking(Rectangle bounds, FImage img) {
        ArrayList<Rectangle> initialObjects = new ArrayList<Rectangle>();
        this.trackingContext.setTargetArea((Shape)bounds);
        this.tracker.selectGoodFeatures(img);
        this.featuresFound = this.featureList.countRemainingFeatures();
        initialObjects.add(bounds);
        this.previousFrame = img;
        return initialObjects;
    }

    public FeatureList getFeatureList() {
        return this.featureList;
    }
}

