/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.haar;

import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.analysis.algorithm.SummedSqTiltAreaTable;
import org.openimaj.image.objectdetection.haar.StageTreeClassifier;
import org.openimaj.image.objectdetection.haar.WeightedRectangle;

@Reference(type=ReferenceType.Inproceedings, author={"Viola, P.", "Jones, M."}, title="Rapid object detection using a boosted cascade of simple features", year="2001", booktitle="Computer Vision and Pattern Recognition, 2001. CVPR 2001. Proceedings of the 2001 IEEE Computer Society Conference on", pages={" I", "511 ", " I", "518 vol.1"}, number="", volume="1", customData={"keywords", " AdaBoost; background regions; boosted simple feature cascade; classifiers; face detection; image processing; image representation; integral image; machine learning; object specific focus-of-attention mechanism; rapid object detection; real-time applications; statistical guarantees; visual object detection; feature extraction; image classification; image representation; learning (artificial intelligence); object detection;", "doi", "10.1109/CVPR.2001.990517", "ISSN", "1063-6919 "})
public abstract class HaarFeature {
    public WeightedRectangle[] rects;
    private final float correctionFactor;
    protected WeightedRectangle[] cachedRects;

    private HaarFeature(WeightedRectangle[] rects, float correctionFactor) {
        this.rects = rects;
        this.correctionFactor = correctionFactor;
        this.cachedRects = new WeightedRectangle[rects.length];
        for (int i = 0; i < this.cachedRects.length; ++i) {
            this.cachedRects[i] = new WeightedRectangle(0, 0, 0, 0, 0.0f);
        }
    }

    final void updateCaches(StageTreeClassifier cascade) {
        this.setScale(cascade.cachedScale, cascade.cachedInvArea);
    }

    public final void setScale(float scale, float invArea) {
        double sum0 = 0.0;
        double area0 = 0.0;
        int base_w = Integer.MAX_VALUE;
        int base_h = Integer.MAX_VALUE;
        int new_base_w = 0;
        int new_base_h = 0;
        boolean flagx = false;
        boolean flagy = false;
        int x0 = 0;
        int y0 = 0;
        WeightedRectangle firstArea = this.rects[0];
        for (WeightedRectangle r : this.rects) {
            if (r.width - 1 >= 0) {
                base_w = Math.min(base_w, r.width - 1);
            }
            if (r.x - firstArea.x - 1 >= 0) {
                base_w = Math.min(base_w, r.x - firstArea.x - 1);
            }
            if (r.height - 1 >= 0) {
                base_h = Math.min(base_h, r.height - 1);
            }
            if (r.y - firstArea.y - 1 < 0) continue;
            base_h = Math.min(base_h, r.y - firstArea.y - 1);
        }
        int kx = firstArea.width / ++base_w;
        int ky = firstArea.height / ++base_h;
        if (kx <= 0) {
            flagx = true;
            new_base_w = Math.round((float)firstArea.width * scale) / kx;
            x0 = Math.round((float)firstArea.x * scale);
        }
        if (ky <= 0) {
            flagy = true;
            new_base_h = Math.round((float)firstArea.height * scale) / ky;
            y0 = Math.round((float)firstArea.y * scale);
        }
        for (int k = 0; k < this.rects.length; ++k) {
            int height;
            int y;
            int width;
            int x;
            WeightedRectangle r = this.rects[k];
            if (flagx) {
                x = (r.x - firstArea.x) * new_base_w / base_w + x0;
                width = r.width * new_base_w / base_w;
            } else {
                x = Math.round((float)r.x * scale);
                width = Math.round((float)r.width * scale);
            }
            if (flagy) {
                y = (r.y - firstArea.y) * new_base_h / base_h + y0;
                height = r.height * new_base_h / base_h;
            } else {
                y = Math.round((float)r.y * scale);
                height = Math.round((float)r.height * scale);
            }
            float correction_ratio = this.correctionFactor * invArea;
            this.cachedRects[k].weight = this.rects[k].weight * correction_ratio;
            this.cachedRects[k].x = x;
            this.cachedRects[k].y = y;
            this.cachedRects[k].width = width;
            this.cachedRects[k].height = height;
            if (k == 0) {
                area0 = width * height;
                continue;
            }
            sum0 += (double)(this.cachedRects[k].weight * (float)width * (float)height);
        }
        this.cachedRects[0].weight = (float)(-sum0 / area0);
    }

    public abstract float computeResponse(SummedSqTiltAreaTable var1, int var2, int var3);

    public static HaarFeature create(List<WeightedRectangle> rectList, boolean tilted) {
        WeightedRectangle[] rects = rectList.toArray(new WeightedRectangle[rectList.size()]);
        if (tilted) {
            return new TiltedFeature(rects);
        }
        return new NormalFeature(rects);
    }

    public static HaarFeature create(boolean tilted, int x0, int y0, int w0, int h0, float wt0, int x1, int y1, int w1, int h1, float wt1) {
        WeightedRectangle[] rects = new WeightedRectangle[]{new WeightedRectangle(x0, y0, w0, h0, wt0), new WeightedRectangle(x1, y1, w1, h1, wt1)};
        return tilted ? new TiltedFeature(rects) : new NormalFeature(rects);
    }

    public static HaarFeature create(boolean tilted, int x0, int y0, int w0, int h0, float wt0, int x1, int y1, int w1, int h1, float wt1, int x2, int y2, int w2, int h2, float wt2) {
        WeightedRectangle[] rects = new WeightedRectangle[]{new WeightedRectangle(x0, y0, w0, h0, wt0), new WeightedRectangle(x1, y1, w1, h1, wt1), new WeightedRectangle(x2, y2, w2, h2, wt2)};
        return tilted ? new TiltedFeature(rects) : new NormalFeature(rects);
    }

    static class NormalFeature
    extends HaarFeature {
        public NormalFeature(WeightedRectangle[] rects) {
            super(rects, 1.0f);
        }

        @Override
        public float computeResponse(SummedSqTiltAreaTable sat, int rx, int ry) {
            float total = 0.0f;
            for (int i = 0; i < this.cachedRects.length; ++i) {
                WeightedRectangle rect = this.cachedRects[i];
                int x = rx + rect.x;
                int y = ry + rect.y;
                int width = rect.width;
                int height = rect.height;
                int yh = y + height;
                int xw = x + width;
                float regionSum = sat.sum.pixels[yh][xw] - sat.sum.pixels[yh][x] - sat.sum.pixels[y][xw] + sat.sum.pixels[y][x];
                total += regionSum * rect.weight;
            }
            return total;
        }
    }

    static class TiltedFeature
    extends HaarFeature {
        public TiltedFeature(WeightedRectangle[] rects) {
            super(rects, 2.0f);
        }

        @Override
        public float computeResponse(SummedSqTiltAreaTable sat, int rx, int ry) {
            float total = 0.0f;
            for (int i = 0; i < this.cachedRects.length; ++i) {
                WeightedRectangle rect = this.cachedRects[i];
                int x = rx + rect.x;
                int y = ry + rect.y;
                int width = rect.width;
                int height = rect.height;
                float p0 = sat.tiltSum.pixels[y][x];
                float p1 = sat.tiltSum.pixels[y + height][x - height];
                float p2 = sat.tiltSum.pixels[y + width][x + width];
                float p3 = sat.tiltSum.pixels[y + width + height][x + width - height];
                float regionSum = p0 - p1 - p2 + p3;
                total += regionSum * rect.weight;
            }
            return total;
        }
    }
}

