/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.processor;

import org.apache.commons.math.stat.StatUtils;
import org.openimaj.ml.timeseries.processor.TimeSeriesProcessor;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;

public class MovingAverageProcessor
implements TimeSeriesProcessor<double[], Double, DoubleTimeSeries> {
    private long length;

    public MovingAverageProcessor(long length) {
        this.length = length;
    }

    @Override
    public void process(DoubleTimeSeries series) {
        long[] times = series.getTimes();
        double[] data = series.getData();
        int size = series.size();
        for (int i = size - 1; i >= 0; --i) {
            long latest = times[i];
            long earliest = latest - this.length;
            DoubleTimeSeries spanoftime = series.get(earliest, latest);
            data[i] = StatUtils.mean((double[])spanoftime.getData());
        }
    }
}

