/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.perceptron;

import java.util.Arrays;
import java.util.List;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.ml.linear.learner.OnlineLearner;
import org.openimaj.util.pair.IndependentPair;

public class SimplePerceptron
implements OnlineLearner<double[], Integer>,
EstimatableModel<double[], Integer> {
    private static final double DEFAULT_LEARNING_RATE = 0.01;
    private static final int DEFAULT_ITERATIONS = 1000;
    double alpha = 0.01;
    private double[] w;
    private int iterations = 1000;

    private SimplePerceptron(double[] w) {
        this.w = w;
    }

    public SimplePerceptron() {
    }

    @Override
    public void process(double[] pt, Integer clazz) {
        if (this.w == null) {
            this.initW(pt.length);
        }
        int y = this.predict(pt);
        System.out.println("w: " + Arrays.toString(this.w));
        this.w[0] = this.w[0] + this.alpha * (double)(clazz - y);
        for (int i = 0; i < pt.length; ++i) {
            this.w[i + 1] = this.w[i + 1] + this.alpha * (double)(clazz - y) * pt[i];
        }
    }

    private void initW(int length) {
        this.w = new double[length + 1];
        this.w[0] = 1.0;
    }

    @Override
    public Integer predict(double[] x) {
        if (this.w == null) {
            return 0;
        }
        return this.w[0] + this.project(x) > 0.0 ? 1 : 0;
    }

    private double project(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * this.w[i + 1];
        }
        return sum;
    }

    public boolean estimate(List<? extends IndependentPair<double[], Integer>> data) {
        this.w = new double[]{1.0, 0.0, 0.0};
        for (int i = 0; i < this.iterations; ++i) {
            this.iteration(data);
            double error = this.calculateError(data);
            if (error < 0.01) break;
        }
        return true;
    }

    private void iteration(List<? extends IndependentPair<double[], Integer>> pts) {
        for (int i = 0; i < pts.size(); ++i) {
            IndependentPair<double[], Integer> pair = pts.get(i);
            this.process((double[])pair.firstObject(), (Integer)pair.secondObject());
        }
    }

    public int numItemsToEstimate() {
        return 1;
    }

    protected double calculateError(List<? extends IndependentPair<double[], Integer>> pts) {
        double error = 0.0;
        for (int i = 0; i < pts.size(); ++i) {
            IndependentPair<double[], Integer> pair = pts.get(i);
            error += (double)Math.abs(this.predict((double[])pts.get(i).firstObject()) - (Integer)pair.secondObject());
        }
        return error / (double)pts.size();
    }

    public double[] computeHyperplanePoint(double[] x) {
        double total = this.w[0];
        int nanindex = -1;
        double[] ret = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            if (nanindex != -1 && Double.isNaN(value)) {
                value = 0.0;
            } else if (Double.isNaN(value)) {
                nanindex = i;
                continue;
            }
            ret[i] = value;
            total += this.w[i + 1] * value;
        }
        if (nanindex != -1) {
            ret[nanindex] = total / -this.w[nanindex + 1];
        }
        return ret;
    }

    public SimplePerceptron clone() {
        return new SimplePerceptron(this.w);
    }

    public double[] getWeights() {
        return this.w;
    }
}

