/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.openimaj.io.WriteableASCII;
import org.openimaj.ml.linear.learner.LearningParameters;
import org.openimaj.ml.linear.learner.init.CurrentUMean;
import org.openimaj.ml.linear.learner.init.CurrentWMean;
import org.openimaj.ml.linear.learner.init.SparseRandomInitStrategy;
import org.openimaj.ml.linear.learner.init.SparseZerosInitStrategy;
import org.openimaj.ml.linear.learner.loss.SquareMissingLossFunction;
import org.openimaj.ml.linear.learner.regul.L1L2Regulariser;

public class BilinearLearnerParameters
extends LearningParameters
implements WriteableASCII {
    public static final String BIAS = "bias";
    public static final String SEED = "seed";
    public static final String WINITSTRAT = "winitstrat";
    public static final String UINITSTRAT = "uinitstrat";
    public static final String EXPANDEDWINITSTRAT = "expandedwinitstrat";
    public static final String EXPANDEDUINITSTRAT = "expandeduinitstrat";
    public static final String BIASINITSTRAT = "biasinitstrat";
    public static final String BICONVEX_MAXITER = "biconvex_maxiter";
    public static final String BICONVEX_TOL = "biconvex_tol";
    public static final String LAMBDA_W = "lambda_w";
    public static final String LAMBDA_U = "lambda_u";
    public static final String LAMBDA = "lambda";
    public static final String ETA0_U = "eta0u";
    public static final String ETA0_W = "eta0w";
    public static final String ETA0_BIAS = "biaseta0";
    public static final String LOSS = "loss";
    public static final String REGUL = "regul";
    public static final String ETASTEPS = "etasteps";
    public static final String FORCE_SPARCITY = "forcesparcity";
    public static final String DAMPENING = "dampening";
    public static final String Z_STANDARDISE = "z_standardise";
    private static final long serialVersionUID = -2059819246888686435L;
    public static final String ETA_GAMMA = "gamma";

    public BilinearLearnerParameters() {
        this.defaults.put(REGUL, new L1L2Regulariser());
        this.defaults.put(LOSS, new SquareMissingLossFunction());
        this.defaults.put(ETA0_U, 0.05);
        this.defaults.put(ETA0_W, 0.05);
        this.defaults.put(LAMBDA, 0.001);
        this.defaults.put(LAMBDA_W, new LearningParameters.Placeholder(this, LAMBDA));
        this.defaults.put(LAMBDA_U, new LearningParameters.Placeholder(this, LAMBDA));
        this.defaults.put(BICONVEX_TOL, 0.01);
        this.defaults.put(BICONVEX_MAXITER, 3);
        this.defaults.put(SEED, -1);
        this.defaults.put(WINITSTRAT, new SparseRandomInitStrategy(0.0, 1.0, 0.5, new Random()));
        this.defaults.put(UINITSTRAT, new SparseRandomInitStrategy(0.0, 1.0, 0.5, new Random()));
        this.defaults.put(EXPANDEDWINITSTRAT, new CurrentWMean());
        this.defaults.put(EXPANDEDUINITSTRAT, new CurrentUMean());
        this.defaults.put(BIAS, false);
        this.defaults.put(BIASINITSTRAT, new SparseZerosInitStrategy());
        this.defaults.put(ETA0_BIAS, 0.05);
        this.defaults.put(ETASTEPS, 3);
        this.defaults.put(FORCE_SPARCITY, true);
        this.defaults.put(DAMPENING, 0.0);
        this.defaults.put(Z_STANDARDISE, false);
        this.defaults.put(ETA_GAMMA, 1.5);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        HashSet a = new HashSet(this.keySet());
        a.addAll(this.defaults.keySet());
        for (String key : a) {
            out.printf("%s: %s\n", key, this.getTyped(key));
        }
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)writer, true);
        try {
            this.writeASCII(pw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pw.flush();
        return writer.toString();
    }

    public String asciiHeader() {
        return "Bilinear Learner Params";
    }

    @Override
    public BilinearLearnerParameters clone() {
        BilinearLearnerParameters ret = new BilinearLearnerParameters();
        for (Map.Entry ent : this.entrySet()) {
            ret.put(ent.getKey(), ent.getValue());
        }
        return ret;
    }
}

