/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.classification.BasicClassificationResult;
import org.openimaj.experiment.evaluation.classification.ClassificationAnalyser;
import org.openimaj.experiment.evaluation.classification.ClassificationEvaluator;
import org.openimaj.experiment.evaluation.classification.ClassificationResult;
import org.openimaj.experiment.evaluation.classification.Classifier;
import org.openimaj.experiment.evaluation.retrieval.RetrievalAnalyser;
import org.openimaj.experiment.evaluation.retrieval.RetrievalEngine;
import org.openimaj.experiment.evaluation.retrieval.RetrievalEvaluator;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.Annotator;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.util.pair.ObjectDoublePair;

public class AnnotationEvaluator<OBJECT extends Identifiable, ANNOTATION> {
    Annotator<OBJECT, ANNOTATION> annotator;
    Dataset<? extends Annotated<OBJECT, ANNOTATION>> testData;
    AnnotationEvaluationEngine<OBJECT, ANNOTATION> engine;

    public AnnotationEvaluator(Annotator<OBJECT, ANNOTATION> annotator, Dataset<? extends Annotated<OBJECT, ANNOTATION>> testData) {
        this.annotator = annotator;
        this.testData = testData;
        this.engine = new AnnotationEvaluationEngine<OBJECT, ANNOTATION>(annotator, testData);
    }

    public <RESULT extends AnalysisResult> ClassificationEvaluator<RESULT, ANNOTATION, OBJECT> newClassificationEvaluator(ClassificationAnalyser<RESULT, ANNOTATION, OBJECT> analyser) {
        return new ClassificationEvaluator(this.engine, this.getObjects(), this.getActual(), analyser);
    }

    public <RESULT extends AnalysisResult> RetrievalEvaluator<RESULT, OBJECT, ANNOTATION> newRetrievalEvaluator(RetrievalAnalyser<RESULT, ANNOTATION, OBJECT> analyser) {
        Set<ANNOTATION> queries = this.getQueries();
        Map<ANNOTATION, Set<OBJECT>> relevant = this.getRelevant(queries);
        return new RetrievalEvaluator(this.engine, relevant, analyser);
    }

    private Collection<OBJECT> getObjects() {
        ArrayList objects = new ArrayList();
        for (Annotated ao : this.testData) {
            objects.add(ao.getObject());
        }
        return objects;
    }

    private Map<OBJECT, Set<ANNOTATION>> getActual() {
        HashMap actual = new HashMap();
        for (Annotated ao : this.testData) {
            actual.put(ao.getObject(), new HashSet(ao.getAnnotations()));
        }
        return actual;
    }

    private Set<ANNOTATION> getQueries() {
        HashSet testAnnotations = new HashSet();
        for (Annotated item : this.testData) {
            testAnnotations.addAll(item.getAnnotations());
        }
        testAnnotations.retainAll(this.annotator.getAnnotations());
        return testAnnotations;
    }

    private Map<ANNOTATION, Set<OBJECT>> getRelevant(Collection<ANNOTATION> queries) {
        HashMap relevant = new HashMap();
        for (ANNOTATION query : queries) {
            HashSet rset = new HashSet();
            relevant.put(query, rset);
            for (Annotated item : this.testData) {
                if (!item.getAnnotations().contains(query)) continue;
                rset.add(item.getObject());
            }
        }
        return relevant;
    }

    static class AnnotationEvaluationEngine<OBJECT extends Identifiable, ANNOTATION>
    implements RetrievalEngine<OBJECT, ANNOTATION>,
    Classifier<ANNOTATION, OBJECT> {
        Map<OBJECT, List<ScoredAnnotation<ANNOTATION>>> results = new HashMap<OBJECT, List<ScoredAnnotation<ANNOTATION>>>();

        public AnnotationEvaluationEngine(Annotator<OBJECT, ANNOTATION> annotator, Dataset<? extends Annotated<OBJECT, ANNOTATION>> testData) {
            for (Annotated item : testData) {
                Identifiable obj = (Identifiable)item.getObject();
                this.results.put(obj, annotator.annotate(obj));
            }
        }

        public List<OBJECT> search(ANNOTATION query) {
            ArrayList<ObjectDoublePair> sr = new ArrayList<ObjectDoublePair>();
            block0: for (Map.Entry<OBJECT, List<ScoredAnnotation<ANNOTATION>>> e : this.results.entrySet()) {
                for (ScoredAnnotation<ANNOTATION> a : e.getValue()) {
                    if (!a.annotation.equals(query)) continue;
                    sr.add(ObjectDoublePair.pair(e.getKey(), (double)a.confidence));
                    continue block0;
                }
            }
            Collections.sort(sr, new Comparator<ObjectDoublePair<OBJECT>>(){

                @Override
                public int compare(ObjectDoublePair<OBJECT> o1, ObjectDoublePair<OBJECT> o2) {
                    if (o1.second == o2.second) {
                        return 0;
                    }
                    if (o1.second < o2.second) {
                        return 1;
                    }
                    return -1;
                }
            });
            return ObjectDoublePair.getFirst(sr);
        }

        public ClassificationResult<ANNOTATION> classify(OBJECT object) {
            BasicClassificationResult res = new BasicClassificationResult();
            for (ScoredAnnotation<ANNOTATION> anno : this.results.get(object)) {
                res.put(anno.annotation, (double)anno.confidence);
            }
            return res;
        }
    }
}

