/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation;

import java.util.List;
import java.util.Set;
import org.openimaj.data.dataset.cache.GroupedListCache;
import org.openimaj.data.dataset.cache.InMemoryGroupedListCache;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.BatchAnnotator;
import org.openimaj.ml.annotation.IncrementalAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;

public class FeatureCachingIncrementalBatchAnnotator<OBJECT, ANNOTATION, FEATURE>
extends IncrementalAnnotator<OBJECT, ANNOTATION> {
    BatchAnnotator<FEATURE, ANNOTATION> batchAnnotator;
    GroupedListCache<ANNOTATION, FEATURE> featureCache;
    private FeatureExtractor<FEATURE, OBJECT> extractor;
    boolean isInvalid = true;

    public FeatureCachingIncrementalBatchAnnotator(FeatureExtractor<FEATURE, OBJECT> extractor, BatchAnnotator<FEATURE, ANNOTATION> batchAnnotator) {
        this.extractor = extractor;
        this.featureCache = new InMemoryGroupedListCache();
        this.batchAnnotator = batchAnnotator;
    }

    public FeatureCachingIncrementalBatchAnnotator(FeatureExtractor<FEATURE, OBJECT> extractor, BatchAnnotator<FEATURE, ANNOTATION> batchAnnotator, GroupedListCache<ANNOTATION, FEATURE> cache) {
        this.extractor = extractor;
        this.batchAnnotator = batchAnnotator;
        this.featureCache = cache;
    }

    @Override
    public void train(Annotated<OBJECT, ANNOTATION> annotated) {
        Object fv = this.extractor.extractFeature(annotated.getObject());
        this.featureCache.add(annotated.getAnnotations(), fv);
        this.isInvalid = true;
    }

    @Override
    public void reset() {
        this.featureCache.reset();
        this.isInvalid = true;
    }

    @Override
    public Set<ANNOTATION> getAnnotations() {
        return this.featureCache.getDataset().getGroups();
    }

    @Override
    public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT object) {
        if (this.isInvalid) {
            this.batchAnnotator.train(this.featureCache.getDataset());
            this.isInvalid = false;
        }
        return this.batchAnnotator.annotate(this.extractor.extractFeature(object));
    }
}

