/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.EllipseUtilities;

public class EllipticInterestPointData
extends InterestPointData {
    private static final long serialVersionUID = 3442580574124477236L;
    public Matrix transform;

    public void setTransform(Matrix transform) {
        this.transform = transform;
    }

    @Override
    public Matrix getTransform() {
        Matrix m = new Matrix(3, 3);
        m.setMatrix(0, 1, 0, 1, this.transform);
        m.set(0, 2, 0.0);
        m.set(1, 2, 0.0);
        m.set(2, 2, 1.0);
        return m;
    }

    @Override
    public Ellipse getEllipse() {
        return EllipseUtilities.fromTransformMatrix2x2((Matrix)this.transform, (float)this.x, (float)this.y, (float)this.scale);
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        super.writeBinary(out);
        out.writeFloat((float)this.transform.get(0, 0));
        out.writeFloat((float)this.transform.get(0, 1));
        out.writeFloat((float)this.transform.get(1, 0));
        out.writeFloat((float)this.transform.get(1, 1));
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        super.writeASCII(out);
        out.format(" %4.2f %4.2f %4.2f %4.2f", Float.valueOf((float)this.transform.get(0, 0)), Float.valueOf((float)this.transform.get(0, 1)), Float.valueOf((float)this.transform.get(1, 0)), Float.valueOf((float)this.transform.get(1, 1)));
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        super.readBinary(in);
        this.transform = new Matrix(2, 2);
        this.transform.set(0, 0, (double)in.readFloat());
        this.transform.set(0, 1, (double)in.readFloat());
        this.transform.set(1, 0, (double)in.readFloat());
        this.transform.set(1, 1, (double)in.readFloat());
        this.setTransform(this.transform);
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        super.readASCII(in);
        this.transform = new Matrix(2, 2);
        this.transform.set(0, 0, (double)in.nextFloat());
        this.transform.set(0, 1, (double)in.nextFloat());
        this.transform.set(1, 0, (double)in.nextFloat());
        this.transform.set(1, 1, (double)in.nextFloat());
        this.setTransform(this.transform);
    }

    @Override
    public EllipticInterestPointData clone() {
        EllipticInterestPointData d = (EllipticInterestPointData)super.clone();
        d.transform = this.transform.copy();
        return d;
    }
}

