/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.engine;

import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramid;
import org.openimaj.image.feature.local.descriptor.gradient.SIFTFeatureProvider;
import org.openimaj.image.feature.local.detector.dog.collector.OctaveKeypointCollector;
import org.openimaj.image.feature.local.detector.dog.extractor.DominantOrientationExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.GradientFeatureExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.OrientationHistogramExtractor;
import org.openimaj.image.feature.local.detector.dog.pyramid.DoGOctaveExtremaFinder;
import org.openimaj.image.feature.local.detector.pyramid.BasicOctaveExtremaFinder;
import org.openimaj.image.feature.local.engine.DoGSIFTEngineOptions;
import org.openimaj.image.feature.local.engine.Engine;
import org.openimaj.image.feature.local.keypoints.Keypoint;

public class MSERSIFTEngine
implements Engine<Keypoint, FImage> {
    DoGSIFTEngineOptions<FImage> options;

    public MSERSIFTEngine() {
        this(new DoGSIFTEngineOptions<FImage>());
    }

    public MSERSIFTEngine(DoGSIFTEngineOptions<FImage> options) {
        this.options = options;
    }

    @Override
    public LocalFeatureList<Keypoint> findFeatures(FImage image) {
        DoGOctaveExtremaFinder finder = new DoGOctaveExtremaFinder(new BasicOctaveExtremaFinder(this.options.magnitudeThreshold, this.options.eigenvalueRatio));
        OctaveKeypointCollector<FImage> collector = new OctaveKeypointCollector<FImage>(new GradientFeatureExtractor(new DominantOrientationExtractor(this.options.peakThreshold, new OrientationHistogramExtractor(this.options.numOriHistBins, this.options.scaling, this.options.smoothingIterations, this.options.samplingSize)), new SIFTFeatureProvider(this.options.numOriBins, this.options.numSpatialBins, this.options.valueThreshold, this.options.gaussianSigma), this.options.magnificationFactor * (float)this.options.numSpatialBins));
        finder.setOctaveInterestPointListener(collector);
        this.options.setOctaveProcessor(finder);
        GaussianPyramid pyr = new GaussianPyramid(this.options);
        pyr.process((Image)image);
        return collector.getFeatures();
    }

    public DoGSIFTEngineOptions<FImage> getOptions() {
        return this.options;
    }
}

