/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.pyramid;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.feature.local.detector.pyramid.AbstractOctaveInterestPointFinder;

public abstract class AbstractOctaveExtremaFinder<OCTAVE extends GaussianOctave<FImage>>
extends AbstractOctaveInterestPointFinder<OCTAVE, FImage> {
    public static final float DEFAULT_EIGENVALUE_RATIO = 10.0f;
    protected float eigenvalueRatio = 10.0f;

    public AbstractOctaveExtremaFinder() {
        this(10.0f);
    }

    public AbstractOctaveExtremaFinder(float eigenvalueRatio) {
        this.eigenvalueRatio = eigenvalueRatio;
    }

    @Override
    public OCTAVE getOctave() {
        return (OCTAVE)((GaussianOctave)this.octave);
    }

    @Override
    public int getCurrentScaleIndex() {
        return this.currentScaleIndex;
    }

    public void process(OCTAVE octave) {
        this.beforeProcess(octave);
        this.octave = octave;
        FImage[] images = (FImage[])((GaussianOctave)octave).images;
        int height = images[0].height;
        int width = images[0].width;
        int borderDist = ((GaussianPyramidOptions)((GaussianOctave)octave).options).getBorderPixels();
        this.currentScaleIndex = 1;
        while (this.currentScaleIndex < images.length - 1) {
            for (int y = borderDist; y < height - borderDist; ++y) {
                for (int x = borderDist; x < width - borderDist; ++x) {
                    float val = images[this.currentScaleIndex].pixels[y][x];
                    if (!this.firstCheck(val, x, y, this.currentScaleIndex, images) || !this.isLocalExtremum(val, images[this.currentScaleIndex - 1], x, y) || !this.isLocalExtremum(val, images[this.currentScaleIndex], x, y) || !this.isLocalExtremum(val, images[this.currentScaleIndex + 1], x, y) || !this.isNotEdge(images[this.currentScaleIndex], x, y)) continue;
                    this.processExtrema(images, this.currentScaleIndex, x, y, ((GaussianOctave)octave).octaveSize);
                }
            }
            ++this.currentScaleIndex;
        }
    }

    protected boolean firstCheck(float val, int x, int y, int scaleIndex, FImage[] images) {
        return true;
    }

    protected void beforeProcess(OCTAVE octave) {
    }

    protected boolean isLocalExtremum(float val, FImage image, int x, int y) {
        float[][] pix = image.pixels;
        if ((double)val > 0.0) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int xx = x - 1; xx <= x + 1; ++xx) {
                    if (!(pix[yy][xx] > val)) continue;
                    return false;
                }
            }
        } else {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int xx = x - 1; xx <= x + 1; ++xx) {
                    if (!(pix[yy][xx] < val)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isNotEdge(FImage image, int x, int y) {
        float[][] pix = image.pixels;
        float H00 = pix[y - 1][x] - 2.0f * pix[y][x] + pix[y + 1][x];
        float H11 = pix[y][x - 1] - 2.0f * pix[y][x] + pix[y][x + 1];
        float H01 = (pix[y + 1][x + 1] - pix[y + 1][x - 1] - (pix[y - 1][x + 1] - pix[y - 1][x - 1])) / 4.0f;
        float det = H00 * H11 - H01 * H01;
        float eigenvalueRatio1 = this.eigenvalueRatio + 1.0f;
        float trace = H00 + H11;
        return det * eigenvalueRatio1 * eigenvalueRatio1 > this.eigenvalueRatio * trace * trace;
    }

    protected abstract void processExtrema(FImage[] var1, int var2, int var3, int var4, float var5);
}

