/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.mser.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analysis.watershed.MergeTreeBuilder;
import org.openimaj.image.analysis.watershed.feature.PixelsFeature;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.feature.local.detector.mser.MSERFeatureGenerator;
import org.openimaj.image.feature.local.detector.mser.gui.ComponentUtils;
import org.openimaj.image.feature.local.detector.mser.gui.ImageUtils;

public class TestGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu jFileMenu = null;
    private JMenuItem jOpenMenuItem = null;
    private ImageUtils.ImagePanel jImagePanel = null;
    private JPanel jControlsPanel = null;
    private List<MergeTreeBuilder> mergeTrees = null;
    protected MBFImage img;
    private JLabel jDeltaLabel = null;
    private JSlider jDeltaSlider = null;
    private JLabel jMaxAreaLabel = null;
    private JSlider jMaxAreaSlider = null;
    private JLabel jMinAreaLabel = null;
    private JSlider jMinAreaSlider1 = null;
    private JLabel jMaxVariationLabel = null;
    private JSlider jMaxVariationSlider1 = null;
    private JLabel jMinDiversityLabel = null;
    private JSlider jMinDiversitySlider = null;

    public TestGUI() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(768, 541);
        this.setJMenuBar(this.getJJMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setTitle("MSER Test Harness");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                System.exit(1);
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.fill = 3;
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            this.jImagePanel = new ImageUtils.ImagePanel();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jImagePanel, gridBagConstraints);
            this.jContentPane.add((Component)this.getJControlsPanel(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getJFileMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getJFileMenu() {
        if (this.jFileMenu == null) {
            this.jFileMenu = new JMenu();
            this.jFileMenu.setText("File");
            this.jFileMenu.add(this.getJOpenMenuItem());
        }
        return this.jFileMenu;
    }

    private JMenuItem getJOpenMenuItem() {
        if (this.jOpenMenuItem == null) {
            this.jOpenMenuItem = new JMenuItem();
            this.jOpenMenuItem.setText("Open");
            this.jOpenMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser jfc = new JFileChooser();
                    int retValue = jfc.showOpenDialog(TestGUI.this);
                    if (retValue == 0) {
                        File f = jfc.getSelectedFile();
                        try {
                            TestGUI.this.loadFile(f);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.jOpenMenuItem;
    }

    private void loadFile(File f) throws IOException {
        System.out.println("Analysing " + f);
        this.img = ImageUtilities.readMBF((File)f);
        System.out.println("Image Dimensions: " + this.img.getWidth() + "x" + this.img.getHeight());
        long start = System.currentTimeMillis();
        MSERFeatureGenerator mser = new MSERFeatureGenerator(1, 1, 1, 0.0f, 0.7f, PixelsFeature.class);
        this.mergeTrees = mser.performWatershed(Transforms.calculateIntensityNTSC((MBFImage)this.img));
        long end = System.currentTimeMillis();
        long timeTaken = end - start;
        System.out.println("--------------------------------------------");
        System.out.println("Time taken: " + timeTaken + " milliseconds");
        System.out.println("Number of pixels: " + this.img.getWidth() * this.img.getHeight());
        System.out.println("Pixels per second: " + (double)(this.img.getWidth() * this.img.getHeight()) / ((double)timeTaken / 1000.0));
        System.out.println("--------------------------------------------");
        this.updateMSER();
    }

    private void updateMSER() {
        System.out.println("Delta: " + this.jDeltaSlider.getValue());
        System.out.println("Max Area: " + this.jMaxAreaSlider.getValue());
        System.out.println("Min Area: " + this.jMinAreaSlider1.getValue());
        System.out.println("Max Variation: " + (float)this.jMaxVariationSlider1.getValue() / 100.0f);
        System.out.println("Min Diversity: " + (float)this.jMinDiversitySlider.getValue() / 100.0f);
        long start = System.currentTimeMillis();
        MSERFeatureGenerator mser = new MSERFeatureGenerator(this.jDeltaSlider.getValue(), this.jMaxAreaSlider.getValue(), this.jMinAreaSlider1.getValue(), (float)this.jMaxVariationSlider1.getValue() / 100.0f, (float)this.jMinDiversitySlider.getValue() / 100.0f, PixelsFeature.class);
        List<org.openimaj.image.analysis.watershed.Component> up_regions = mser.performMSERDetection(this.mergeTrees, MSERFeatureGenerator.MSERDirection.Up);
        List<org.openimaj.image.analysis.watershed.Component> down_regions = mser.performMSERDetection(this.mergeTrees, MSERFeatureGenerator.MSERDirection.Down);
        long end = System.currentTimeMillis();
        long timeTaken = end - start;
        System.out.println("--------------------------------------------");
        System.out.println("Time taken: " + timeTaken + " milliseconds");
        System.out.println("Detected " + (up_regions.size() + down_regions.size()) + " regions");
        System.out.println("--------------------------------------------");
        BufferedImage bimg = ComponentUtils.plotComponentList(up_regions, ImageUtils.copyImage(ImageUtilities.createBufferedImage((Image)this.img)), Color.yellow);
        bimg = ComponentUtils.plotComponentList(down_regions, bimg, Color.blue);
        this.jImagePanel.setImage(bimg);
    }

    private JPanel getJControlsPanel() {
        if (this.jControlsPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 3;
            gridBagConstraints11.gridy = 9;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridx = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridy = 8;
            this.jMinDiversityLabel = new JLabel();
            this.jMinDiversityLabel.setText("Minimum Diversity");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 7;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.gridx = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 6;
            this.jMaxVariationLabel = new JLabel();
            this.jMaxVariationLabel.setText("Maximum Variation");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 5;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridx = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 4;
            this.jMinAreaLabel = new JLabel();
            this.jMinAreaLabel.setText("Minimum Area");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 2;
            this.jMaxAreaLabel = new JLabel();
            this.jMaxAreaLabel.setText("Maximum Area");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            this.jDeltaLabel = new JLabel();
            this.jDeltaLabel.setText("Delta");
            this.jControlsPanel = new JPanel();
            this.jControlsPanel.setLayout(new GridBagLayout());
            this.jControlsPanel.setBorder(BorderFactory.createBevelBorder(0));
            this.jControlsPanel.add((Component)this.jDeltaLabel, gridBagConstraints3);
            this.jControlsPanel.add((Component)this.getJDeltaSlider(), gridBagConstraints2);
            this.jControlsPanel.add((Component)this.jMaxAreaLabel, gridBagConstraints4);
            this.jControlsPanel.add((Component)this.getJMaxAreaSlider(), gridBagConstraints5);
            this.jControlsPanel.add((Component)this.jMinAreaLabel, gridBagConstraints6);
            this.jControlsPanel.add((Component)this.getJMinAreaSlider1(), gridBagConstraints7);
            this.jControlsPanel.add((Component)this.jMaxVariationLabel, gridBagConstraints8);
            this.jControlsPanel.add((Component)this.getJMaxVariationSlider1(), gridBagConstraints9);
            this.jControlsPanel.add((Component)this.jMinDiversityLabel, gridBagConstraints10);
            this.jControlsPanel.add((Component)this.getJMinDiversitySlider(), gridBagConstraints11);
        }
        return this.jControlsPanel;
    }

    private JSlider getJDeltaSlider() {
        if (this.jDeltaSlider == null) {
            this.jDeltaSlider = new JSlider();
            this.jDeltaSlider.setMaximum(255);
            this.jDeltaSlider.setValue(10);
            this.jDeltaSlider.setMajorTickSpacing(50);
            this.jDeltaSlider.setPaintTicks(true);
            this.jDeltaSlider.setPaintLabels(true);
            this.jDeltaSlider.setMinorTickSpacing(10);
            this.jDeltaSlider.setMinimum(0);
            this.jDeltaSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!TestGUI.this.jDeltaSlider.getValueIsAdjusting()) {
                        TestGUI.this.updateMSER();
                    }
                }
            });
        }
        return this.jDeltaSlider;
    }

    private JSlider getJMaxAreaSlider() {
        if (this.jMaxAreaSlider == null) {
            this.jMaxAreaSlider = new JSlider();
            this.jMaxAreaSlider.setPaintTicks(true);
            this.jMaxAreaSlider.setMaximum(100000);
            this.jMaxAreaSlider.setMajorTickSpacing(50000);
            this.jMaxAreaSlider.setMinorTickSpacing(5000);
            this.jMaxAreaSlider.setValue(10000);
            this.jMaxAreaSlider.setPaintLabels(true);
            this.jMaxAreaSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!TestGUI.this.jMaxAreaSlider.getValueIsAdjusting()) {
                        TestGUI.this.updateMSER();
                    }
                }
            });
        }
        return this.jMaxAreaSlider;
    }

    private JSlider getJMinAreaSlider1() {
        if (this.jMinAreaSlider1 == null) {
            this.jMinAreaSlider1 = new JSlider();
            this.jMinAreaSlider1.setMajorTickSpacing(200);
            this.jMinAreaSlider1.setPaintTicks(true);
            this.jMinAreaSlider1.setMaximum(1000);
            this.jMinAreaSlider1.setValue(1);
            this.jMinAreaSlider1.setPaintLabels(true);
            this.jMinAreaSlider1.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!TestGUI.this.jMinAreaSlider1.getValueIsAdjusting()) {
                        TestGUI.this.updateMSER();
                    }
                }
            });
        }
        return this.jMinAreaSlider1;
    }

    private JSlider getJMaxVariationSlider1() {
        if (this.jMaxVariationSlider1 == null) {
            this.jMaxVariationSlider1 = new JSlider();
            this.jMaxVariationSlider1.setMaximum(1000);
            this.jMaxVariationSlider1.setPaintLabels(true);
            this.jMaxVariationSlider1.setPaintTicks(true);
            this.jMaxVariationSlider1.setValue(1000);
            this.jMaxVariationSlider1.setMajorTickSpacing(200);
            this.jMaxVariationSlider1.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!TestGUI.this.jMaxVariationSlider1.getValueIsAdjusting()) {
                        TestGUI.this.updateMSER();
                    }
                }
            });
        }
        return this.jMaxVariationSlider1;
    }

    private JSlider getJMinDiversitySlider() {
        if (this.jMinDiversitySlider == null) {
            this.jMinDiversitySlider = new JSlider();
            this.jMinDiversitySlider.setMajorTickSpacing(20);
            this.jMinDiversitySlider.setPaintTicks(true);
            this.jMinDiversitySlider.setEnabled(true);
            this.jMinDiversitySlider.setPaintLabels(true);
            this.jMinDiversitySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!TestGUI.this.jMinDiversitySlider.getValueIsAdjusting()) {
                        TestGUI.this.updateMSER();
                    }
                }
            });
        }
        return this.jMinDiversitySlider;
    }

    public static void main(String[] args) throws IOException {
        TestGUI t = new TestGUI();
        t.setVisible(true);
        t.loadFile(new File("test-images/spotty-cat.jpg"));
    }
}

