/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.ipd.extractor;

import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProvider;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProviderFactory;
import org.openimaj.image.feature.local.detector.dog.extractor.AbstractDominantOrientationExtractor;
import org.openimaj.image.feature.local.engine.ipd.InterestPointImageExtractorProperties;
import org.openimaj.image.feature.local.extraction.FeatureVectorExtractor;
import org.openimaj.image.feature.local.extraction.GradientScaleSpaceImageExtractorProperties;
import org.openimaj.image.feature.local.extraction.ScaleSpaceImageExtractorProperties;
import org.openimaj.image.processing.convolution.FImageGradients;

public class InterestPointGradientFeatureExtractor
implements FeatureVectorExtractor<OrientedFeatureVector, InterestPointImageExtractorProperties<Float, FImage>> {
    private static final Float INVALID_PIXEL_VALUE = Float.valueOf(Float.NaN);
    AbstractDominantOrientationExtractor dominantOrientationExtractor;
    GradientFeatureProviderFactory factory;
    private GradientScaleSpaceImageExtractorProperties<FImage> currentGradientProperties = new GradientScaleSpaceImageExtractorProperties();

    public InterestPointGradientFeatureExtractor(AbstractDominantOrientationExtractor dominantOrientationExtractor, GradientFeatureProviderFactory factory) {
        this.dominantOrientationExtractor = dominantOrientationExtractor;
        this.factory = factory;
    }

    public GradientScaleSpaceImageExtractorProperties<FImage> getCurrentGradientProps(ScaleSpaceImageExtractorProperties<FImage> properties) {
        if (properties.image != this.currentGradientProperties.image) {
            this.currentGradientProperties.image = properties.image;
            if (this.currentGradientProperties.orientation == null || this.currentGradientProperties.orientation.height != ((FImage)this.currentGradientProperties.image).height || this.currentGradientProperties.orientation.width != ((FImage)this.currentGradientProperties.image).width) {
                this.currentGradientProperties.orientation = new FImage(((FImage)this.currentGradientProperties.image).width, ((FImage)this.currentGradientProperties.image).height);
                this.currentGradientProperties.magnitude = new FImage(((FImage)this.currentGradientProperties.image).width, ((FImage)this.currentGradientProperties.image).height);
            }
            FImageGradients.gradientMagnitudesAndOrientations((FImage)((FImage)this.currentGradientProperties.image), (FImage)this.currentGradientProperties.magnitude, (FImage)this.currentGradientProperties.orientation);
        }
        this.currentGradientProperties.x = properties.x;
        this.currentGradientProperties.y = properties.y;
        this.currentGradientProperties.scale = properties.scale;
        return this.currentGradientProperties;
    }

    public OrientedFeatureVector[] extractFeature(InterestPointImageExtractorProperties<Float, FImage> properties) {
        GradientScaleSpaceImageExtractorProperties<FImage> gprops = this.getCurrentGradientProps(properties);
        float[] dominantOrientations = this.dominantOrientationExtractor.extractFeatureRaw(gprops);
        OrientedFeatureVector[] ret = new OrientedFeatureVector[dominantOrientations.length];
        for (int i = 0; i < dominantOrientations.length; ++i) {
            ret[i] = this.createFeature(properties, dominantOrientations[i]);
        }
        return ret;
    }

    protected OrientedFeatureVector createFeature(InterestPointImageExtractorProperties<Float, FImage> properties, float orientation) {
        GradientFeatureProvider provider = this.factory.newProvider();
        provider.setPatchOrientation(orientation);
        for (int y = 0; y < properties.featureWindowSize; ++y) {
            for (int x = 0; x < properties.featureWindowSize; ++x) {
                if (((FImage)properties.image).pixels[y][x] == INVALID_PIXEL_VALUE.floatValue()) continue;
                float sx = (0.5f + (float)x) / (float)properties.featureWindowSize;
                float sy = (0.5f + (float)y) / (float)properties.featureWindowSize;
                provider.addSample(sx, sy, this.currentGradientProperties.magnitude.pixels[y][x], this.currentGradientProperties.orientation.pixels[y][x]);
            }
        }
        return provider.getFeatureVector();
    }
}

