/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.extractor;

import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProvider;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProviderFactory;
import org.openimaj.image.feature.local.detector.dog.extractor.AbstractDominantOrientationExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.ScaleSpaceFeatureExtractor;
import org.openimaj.image.feature.local.extraction.GradientScaleSpaceImageExtractorProperties;
import org.openimaj.image.feature.local.extraction.ScaleSpaceImageExtractorProperties;
import org.openimaj.image.processing.convolution.FImageGradients;

public class GradientFeatureExtractor
implements ScaleSpaceFeatureExtractor<OrientedFeatureVector, FImage> {
    AbstractDominantOrientationExtractor dominantOrientationExtractor;
    GradientFeatureProviderFactory factory;
    private GradientScaleSpaceImageExtractorProperties<FImage> currentGradientProperties = new GradientScaleSpaceImageExtractorProperties();
    protected float magnification = 12.0f;

    public GradientFeatureExtractor(AbstractDominantOrientationExtractor dominantOrientationExtractor, GradientFeatureProviderFactory factory) {
        this.dominantOrientationExtractor = dominantOrientationExtractor;
        this.factory = factory;
    }

    public GradientFeatureExtractor(AbstractDominantOrientationExtractor dominantOrientationExtractor, GradientFeatureProviderFactory factory, float magnification) {
        this(dominantOrientationExtractor, factory);
        this.magnification = magnification;
    }

    public OrientedFeatureVector[] extractFeature(ScaleSpaceImageExtractorProperties<FImage> properties) {
        GradientScaleSpaceImageExtractorProperties<FImage> gprops = this.getCurrentGradientProps(properties);
        float[] dominantOrientations = this.dominantOrientationExtractor.extractFeatureRaw(gprops);
        OrientedFeatureVector[] ret = new OrientedFeatureVector[dominantOrientations.length];
        for (int i = 0; i < dominantOrientations.length; ++i) {
            ret[i] = this.createFeature(dominantOrientations[i]);
        }
        return ret;
    }

    public GradientScaleSpaceImageExtractorProperties<FImage> getCurrentGradientProps(ScaleSpaceImageExtractorProperties<FImage> properties) {
        if (properties.image != this.currentGradientProperties.image) {
            this.currentGradientProperties.image = properties.image;
            if (this.currentGradientProperties.orientation == null || this.currentGradientProperties.orientation.height != ((FImage)this.currentGradientProperties.image).height || this.currentGradientProperties.orientation.width != ((FImage)this.currentGradientProperties.image).width) {
                this.currentGradientProperties.orientation = new FImage(((FImage)this.currentGradientProperties.image).width, ((FImage)this.currentGradientProperties.image).height);
                this.currentGradientProperties.magnitude = new FImage(((FImage)this.currentGradientProperties.image).width, ((FImage)this.currentGradientProperties.image).height);
            }
            FImageGradients.gradientMagnitudesAndOrientations((FImage)((FImage)this.currentGradientProperties.image), (FImage)this.currentGradientProperties.magnitude, (FImage)this.currentGradientProperties.orientation);
        }
        this.currentGradientProperties.x = properties.x;
        this.currentGradientProperties.y = properties.y;
        this.currentGradientProperties.scale = properties.scale;
        return this.currentGradientProperties;
    }

    protected OrientedFeatureVector createFeature(float orientation) {
        float fx = this.currentGradientProperties.x;
        float fy = this.currentGradientProperties.y;
        float scale = this.currentGradientProperties.scale;
        GradientFeatureProvider sfe = this.factory.newProvider();
        sfe.setPatchOrientation(orientation);
        int ix = Math.round(fx);
        int iy = Math.round(fy);
        float sin = (float)Math.sin(orientation);
        float cos = (float)Math.cos(orientation);
        float oversampling = sfe.getOversamplingAmount();
        float boundingBoxSize = this.magnification * scale;
        float extraSampling = oversampling * boundingBoxSize;
        float samplingBoxSize = extraSampling + boundingBoxSize + extraSampling;
        float orientedSamplingBoxSize = Math.abs(sin * samplingBoxSize) + Math.abs(cos * samplingBoxSize);
        int orientedSamplingBoxHalfSize = Math.round(orientedSamplingBoxSize / 2.0f);
        FImage mag = this.currentGradientProperties.magnitude;
        FImage ori = this.currentGradientProperties.orientation;
        int width = mag.width;
        int height = mag.height;
        for (int y = -orientedSamplingBoxHalfSize; y <= orientedSamplingBoxHalfSize; ++y) {
            for (int x = -orientedSamplingBoxHalfSize; x <= orientedSamplingBoxHalfSize; ++x) {
                int px = x + ix;
                int py = y + iy;
                if (px < 0 || px >= width || py < 0 || py >= height) continue;
                float sx = 0.5f + (-sin * (float)y + cos * (float)x - (fx - (float)ix)) / boundingBoxSize;
                float sy = 0.5f + (cos * (float)y + sin * (float)x - (fy - (float)iy)) / boundingBoxSize;
                if (!(sx > -oversampling) || !(sx < 1.0f + oversampling) || !(sy > -oversampling) || !(sy < 1.0f + oversampling)) continue;
                sfe.addSample(sx, sy, mag.pixels[py][px], ori.pixels[py][px]);
            }
        }
        return sfe.getFeatureVector();
    }
}

