/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.descriptor.gradient;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProvider;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProviderFactory;
import org.openimaj.util.array.ArrayUtils;

@References(references={@Reference(type=ReferenceType.Article, author={"David Lowe"}, title="Distinctive image features from scale-invariant keypoints", year="2004", journal="IJCV", pages={"91", "110"}, month="January", number="2", volume="60"), @Reference(type=ReferenceType.Inproceedings, author={"David Lowe"}, title="Object recognition from local scale-invariant features", year="1999", booktitle="Proc. of the International Conference on Computer Vision {ICCV}", pages={"1150", "1157"})})
public class SIFTFeatureProvider
implements GradientFeatureProvider,
GradientFeatureProviderFactory {
    private static final float TWO_PI_FLOAT = (float)Math.PI * 2;
    protected int numOriBins = 8;
    protected int numSpatialBins = 4;
    protected float valueThreshold = 0.2f;
    protected float sigmaSq2 = 0.5f;
    protected float gaussianSigma = 1.0f;
    protected float[] vec;
    protected float patchOrientation;

    public SIFTFeatureProvider() {
        this.vec = new float[this.numSpatialBins * this.numSpatialBins * this.numOriBins];
    }

    public SIFTFeatureProvider(int numOriBins, int numSpatialBins) {
        this(numOriBins, numSpatialBins, 0.2f, 1.0f);
    }

    public SIFTFeatureProvider(int numOriBins, int numSpatialBins, float valueThreshold, float gaussianSigma) {
        this.numOriBins = numOriBins;
        this.numSpatialBins = numSpatialBins;
        this.valueThreshold = valueThreshold;
        this.gaussianSigma = gaussianSigma;
        this.vec = new float[numSpatialBins * numSpatialBins * numOriBins];
        float sigma = gaussianSigma / (0.5f * (float)numSpatialBins);
        this.sigmaSq2 = 2.0f * sigma * sigma;
    }

    @Override
    public void addSample(float x, float y, float gradmag, float gradori) {
        float f;
        float dx = 0.5f - x;
        float dy = 0.5f - y;
        float weight = (float)Math.exp(-(dx * dx + dy * dy) / this.sigmaSq2);
        float wmag = weight * gradmag;
        float ori = gradori - this.patchOrientation;
        ori = f >= 0.0f ? ori : (ori %= (float)Math.PI * 2) + (float)Math.PI * 2;
        this.interpolateSample(x, y, wmag, ori);
    }

    protected void interpolateSample(float x, float y, float magnitude, float orientation) {
        float px = (float)this.numSpatialBins * x - 0.5f;
        float py = (float)this.numSpatialBins * y - 0.5f;
        float po = (float)this.numOriBins * orientation / ((float)Math.PI * 2);
        int xi = (int)Math.floor(px);
        int yi = (int)Math.floor(py);
        int oi = (int)Math.floor(po);
        float xf = px - (float)xi;
        float yf = py - (float)yi;
        float of = po - (float)oi;
        for (int yy = 0; yy < 2; ++yy) {
            int yindex = yi + yy;
            if (yindex < 0 || yindex >= this.numSpatialBins) continue;
            float yweight = magnitude * (yy == 0 ? 1.0f - yf : yf);
            for (int xx = 0; xx < 2; ++xx) {
                int xindex = xi + xx;
                if (xindex < 0 || xindex >= this.numSpatialBins) continue;
                float xweight = yweight * (xx == 0 ? 1.0f - xf : xf);
                for (int oo = 0; oo < 2; ++oo) {
                    int oindex = oi + oo;
                    if (oindex >= this.numOriBins) {
                        oindex = 0;
                    }
                    float oweight = xweight * (oo == 0 ? 1.0f - of : of);
                    int n = this.numSpatialBins * this.numOriBins * yindex + this.numOriBins * xindex + oindex;
                    this.vec[n] = this.vec[n] + oweight;
                }
            }
        }
    }

    @Override
    public OrientedFeatureVector getFeatureVector() {
        ArrayUtils.normalise((float[])this.vec);
        boolean changed = false;
        for (int i = 0; i < this.vec.length; ++i) {
            if (!(this.vec[i] > this.valueThreshold)) continue;
            this.vec[i] = this.valueThreshold;
            changed = true;
        }
        if (changed) {
            ArrayUtils.normalise((float[])this.vec);
        }
        OrientedFeatureVector fv = new OrientedFeatureVector(this.vec.length, this.patchOrientation);
        for (int i = 0; i < this.vec.length; ++i) {
            int intval = (int)(512.0 * (double)this.vec[i]);
            ((byte[])fv.values)[i] = (byte)(Math.min(255, intval) - 128);
        }
        return fv;
    }

    @Override
    public void setPatchOrientation(float patchOrientation) {
        this.patchOrientation = patchOrientation;
    }

    @Override
    public GradientFeatureProvider newProvider() {
        return new SIFTFeatureProvider(this.numOriBins, this.numSpatialBins, this.valueThreshold, this.gaussianSigma);
    }

    @Override
    public float getOversamplingAmount() {
        return 1.0f / (float)this.numSpatialBins / 2.0f;
    }
}

