/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.aggregate;

import java.util.List;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.SparseDoubleFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.image.feature.local.aggregate.VectorAggregator;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.util.pair.IndependentPair;

public class SoftBagOfVisualWords<DATATYPE, DISTANCE>
implements VectorAggregator<ArrayFeatureVector<DATATYPE>, SparseDoubleFV> {
    private SoftAssigner<DATATYPE, DISTANCE> assigner;

    public SoftBagOfVisualWords(SoftAssigner<DATATYPE, DISTANCE> assigner) {
        this.assigner = assigner;
    }

    @Override
    public SparseDoubleFV aggregate(List<? extends LocalFeature<?, ? extends ArrayFeatureVector<DATATYPE>>> features) {
        SparseDoubleFV fv = new SparseDoubleFV(this.assigner.numDimensions());
        for (LocalFeature<?, ArrayFeatureVector<DATATYPE>> localFeature : features) {
            IndependentPair a = this.assigner.assignWeighted(((ArrayFeatureVector)localFeature.getFeatureVector()).values);
            this.increment(fv, a);
        }
        return fv;
    }

    private void increment(SparseDoubleFV fv, IndependentPair<int[], DISTANCE> a) {
        int[] assignments = (int[])a.firstObject();
        Object distances = a.getSecondObject();
        if (distances instanceof byte[]) {
            for (int i = 0; i < assignments.length; ++i) {
                fv.values.increment(assignments[i], (double)((byte[])distances)[i]);
            }
        } else if (distances instanceof short[]) {
            for (int i = 0; i < assignments.length; ++i) {
                fv.values.increment(assignments[i], (double)((short[])distances)[i]);
            }
        } else if (distances instanceof int[]) {
            for (int i = 0; i < assignments.length; ++i) {
                fv.values.increment(assignments[i], (double)((int[])distances)[i]);
            }
        } else if (distances instanceof long[]) {
            for (int i = 0; i < assignments.length; ++i) {
                fv.values.increment(assignments[i], (double)((long[])distances)[i]);
            }
        } else if (distances instanceof float[]) {
            for (int i = 0; i < assignments.length; ++i) {
                fv.values.increment(assignments[i], (double)((float[])distances)[i]);
            }
        } else if (distances instanceof double[]) {
            for (int i = 0; i < assignments.length; ++i) {
                fv.values.increment(assignments[i], ((double[])distances)[i]);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported type");
        }
    }
}

