/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.processing.algorithm.FourierTransform;

@References(references={@Reference(type=ReferenceType.Inproceedings, author={"Ke, Yan", "Tang, Xiaoou", "Jing, Feng"}, title="The Design of High-Level Features for Photo Quality Assessment", year="2006", booktitle="Proceedings of the 2006 IEEE Computer Society Conference on Computer Vision and Pattern Recognition - Volume 1", pages={"419", "", "426"}, url="http://dx.doi.org/10.1109/CVPR.2006.303", publisher="IEEE Computer Society", series="CVPR '06", customData={"isbn", "0-7695-2597-0", "numpages", "8", "doi", "10.1109/CVPR.2006.303", "acmid", "1153495", "address", "Washington, DC, USA"}), @Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh", "Yuan-Chen Ho", "Brian A. Barsky", "Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})})
public class SharpPixelProportion
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    double bpp = 0.0;
    private float threshold = 2.0f;

    public SharpPixelProportion() {
    }

    public SharpPixelProportion(float threshold) {
        this.threshold = threshold;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.bpp});
    }

    public void analyseImage(FImage image) {
        FourierTransform ft = new FourierTransform(image, false);
        FImage mag = ft.getMagnitude();
        int count = 0;
        for (int y = 0; y < mag.height; ++y) {
            for (int x = 0; x < mag.width; ++x) {
                if (!(Math.abs(mag.pixels[y][x]) > this.threshold)) continue;
                ++count;
            }
        }
        this.bpp = (double)count / (double)(mag.height * mag.width);
        DisplayUtilities.display((Image)image, (String)("" + this.bpp));
    }

    public double getBlurredPixelProportion() {
        return this.bpp;
    }
}

