/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient.dsift;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.openimaj.feature.FloatFV;
import org.openimaj.image.feature.dense.gradient.dsift.AbstractDSIFTKeypoint;

public class FloatDSIFTKeypoint
extends AbstractDSIFTKeypoint<FloatFV, float[]> {
    static final long serialVersionUID = 12345545L;

    public FloatDSIFTKeypoint() {
        this(128);
    }

    public FloatDSIFTKeypoint(int length) {
        this.descriptor = new float[length];
    }

    public FloatDSIFTKeypoint(float x, float y, float[] descriptor, float energy) {
        this.x = x;
        this.y = y;
        this.descriptor = descriptor;
        this.energy = energy;
    }

    public FloatFV getFeatureVector() {
        return new FloatFV((float[])this.descriptor);
    }

    public String toString() {
        return "FloatDSIFTKeypoint(" + this.x + ", " + this.y + ")";
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.energy);
        for (float f : (float[])this.descriptor) {
            out.writeFloat(f);
        }
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.write(this.x + " " + this.y + " " + this.energy + "\n");
        for (int i = 0; i < ((float[])this.descriptor).length; ++i) {
            if (i > 0 && i % 20 == 0) {
                out.println();
            }
            out.print(" %f" + ((float[])this.descriptor)[i]);
        }
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.energy = in.readFloat();
        for (int i = 0; i < ((float[])this.descriptor).length; ++i) {
            ((float[])this.descriptor)[i] = in.readFloat();
        }
    }

    public void readASCII(Scanner in) throws IOException {
        this.x = in.nextFloat();
        this.y = in.nextFloat();
        this.energy = in.nextFloat();
        int i = 0;
        while (i < ((float[])this.descriptor).length) {
            String line = in.nextLine();
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                ((float[])this.descriptor)[i] = Float.parseFloat(st.nextToken());
                ++i;
            }
        }
    }
}

