/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient.dsift;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.openimaj.feature.ByteFV;
import org.openimaj.image.feature.dense.gradient.dsift.AbstractDSIFTKeypoint;

public class ByteDSIFTKeypoint
extends AbstractDSIFTKeypoint<ByteFV, byte[]> {
    static final long serialVersionUID = 12345545L;

    public ByteDSIFTKeypoint() {
        this(128);
    }

    public ByteDSIFTKeypoint(int length) {
        this.descriptor = new byte[length];
    }

    public ByteDSIFTKeypoint(float x, float y, byte[] descriptor, float energy) {
        this.x = x;
        this.y = y;
        this.descriptor = descriptor;
        this.energy = energy;
    }

    public ByteDSIFTKeypoint(float x, float y, float[] fdescriptor, float energy) {
        this.x = x;
        this.y = y;
        this.energy = energy;
        this.descriptor = new byte[fdescriptor.length];
        for (int i = 0; i < ((byte[])this.descriptor).length; ++i) {
            int intval = (int)(512.0 * (double)fdescriptor[i]);
            ((byte[])this.descriptor)[i] = (byte)(Math.min(255, intval) - 128);
        }
    }

    public ByteFV getFeatureVector() {
        return new ByteFV((byte[])this.descriptor);
    }

    public String toString() {
        return "ByteDSIFTKeypoint(" + this.x + ", " + this.y + ")";
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.energy);
        out.write((byte[])this.descriptor);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.getLocation().writeASCII(out);
        out.write(this.x + " " + this.y + " " + this.energy + "\n");
        for (int i = 0; i < ((byte[])this.descriptor).length; ++i) {
            if (i > 0 && i % 20 == 0) {
                out.println();
            }
            out.print(" " + (((byte[])this.descriptor)[i] + 128));
        }
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.energy = in.readFloat();
        in.readFully((byte[])this.descriptor);
    }

    public void readASCII(Scanner in) throws IOException {
        this.x = in.nextFloat();
        this.y = in.nextFloat();
        this.energy = in.nextFloat();
        int i = 0;
        while (i < ((byte[])this.descriptor).length) {
            String line = in.nextLine();
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                ((byte[])this.descriptor)[i] = (byte)(Integer.parseInt(st.nextToken()) - 128);
                ++i;
            }
        }
    }
}

