/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.recognition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.cache.GroupedListCache;
import org.openimaj.data.dataset.cache.InMemoryGroupedListCache;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.recognition.FaceRecogniser;
import org.openimaj.io.IOUtils;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.ScoredAnnotation;

abstract class LazyFaceRecogniser<FACE extends DetectedFace, PERSON, EXTRACTOR extends FeatureExtractor<?, FACE>>
extends FaceRecogniser<FACE, PERSON> {
    EXTRACTOR extractor;
    FaceRecogniser<FACE, PERSON> internalRecogniser;
    GroupedListCache<PERSON, FACE> faceCache;
    boolean isInvalid = true;

    protected LazyFaceRecogniser() {
    }

    public LazyFaceRecogniser(EXTRACTOR extractor, FaceRecogniser<FACE, PERSON> internalRecogniser) {
        this.extractor = extractor;
        this.internalRecogniser = internalRecogniser;
        this.faceCache = new InMemoryGroupedListCache();
    }

    public void readBinary(DataInput in) throws IOException {
        LazyFaceRecogniser wrapper = (LazyFaceRecogniser)((Object)IOUtils.read((DataInput)in));
        this.extractor = wrapper.extractor;
        this.faceCache = wrapper.faceCache;
        this.internalRecogniser = wrapper.internalRecogniser;
        this.isInvalid = wrapper.isInvalid;
    }

    public void writeBinary(DataOutput out) throws IOException {
        IOUtils.write((Object)((Object)this), (DataOutput)out);
    }

    public byte[] binaryHeader() {
        return "BFRec".getBytes();
    }

    public void train(Annotated<FACE, PERSON> annotated) {
        this.faceCache.add(annotated.getAnnotations(), annotated.getObject());
        this.isInvalid = true;
    }

    public void reset() {
        this.internalRecogniser.reset();
        this.faceCache.reset();
        this.isInvalid = true;
    }

    public Set<PERSON> getAnnotations() {
        return this.faceCache.getDataset().getGroups();
    }

    protected abstract void beforeBatchTrain(GroupedDataset<PERSON, ListDataset<FACE>, FACE> var1);

    private void retrain() {
        if (this.isInvalid) {
            GroupedDataset dataset = this.faceCache.getDataset();
            this.beforeBatchTrain(dataset);
            this.internalRecogniser.train(dataset);
            this.isInvalid = false;
        }
    }

    @Override
    public List<ScoredAnnotation<PERSON>> annotate(FACE object, Collection<PERSON> restrict) {
        this.retrain();
        return this.internalRecogniser.annotate(object, restrict);
    }

    @Override
    public List<ScoredAnnotation<PERSON>> annotate(FACE object) {
        this.retrain();
        return this.internalRecogniser.annotate(object);
    }
}

