/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.recognition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.face.detection.DatasetFaceDetector;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processing.face.recognition.FaceRecogniser;
import org.openimaj.io.IOUtils;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.io.WriteableBinary;
import org.openimaj.ml.annotation.AnnotatedObject;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.util.pair.IndependentPair;

public class FaceRecognitionEngine<FACE extends DetectedFace, PERSON>
implements ReadWriteableBinary {
    private static final Logger logger = Logger.getLogger(FaceRecognitionEngine.class);
    protected FaceDetector<FACE, FImage> detector;
    protected FaceRecogniser<FACE, PERSON> recogniser;

    protected FaceRecognitionEngine() {
    }

    public FaceRecognitionEngine(FaceDetector<FACE, FImage> detector, FaceRecogniser<FACE, PERSON> recogniser) {
        this.detector = detector;
        this.recogniser = recogniser;
    }

    public static <FACE extends DetectedFace, EXTRACTOR extends FeatureExtractor<?, FACE>, PERSON> FaceRecognitionEngine<FACE, PERSON> create(FaceDetector<FACE, FImage> detector, FaceRecogniser<FACE, PERSON> recogniser) {
        return new FaceRecognitionEngine<FACE, PERSON>(detector, recogniser);
    }

    public FaceDetector<FACE, FImage> getDetector() {
        return this.detector;
    }

    public FaceRecogniser<FACE, PERSON> getRecogniser() {
        return this.recogniser;
    }

    public void save(File file) throws IOException {
        IOUtils.writeBinaryFull((File)file, (WriteableBinary)this);
    }

    public static <O extends DetectedFace, P> FaceRecognitionEngine<O, P> load(File file) throws IOException {
        FaceRecognitionEngine engine = (FaceRecognitionEngine)IOUtils.read((File)file);
        return engine;
    }

    public void train(GroupedDataset<PERSON, ListDataset<FImage>, FImage> dataset) {
        GroupedDataset<PERSON, ListDataset<FACE>, FACE> faceDataset = DatasetFaceDetector.process(dataset, this.detector);
        this.recogniser.train(faceDataset);
    }

    public FACE train(PERSON person, FImage image) {
        List<FACE> faces = this.detector.detectFaces(image);
        if (faces == null || faces.size() == 0) {
            logger.warn((Object)"no face detected");
            return null;
        }
        if (faces.size() == 1) {
            this.recogniser.train(AnnotatedObject.create(faces.get(0), person));
            return (FACE)((DetectedFace)faces.get(0));
        }
        logger.warn((Object)"More than one face found. Choosing biggest.");
        FACE face = DatasetFaceDetector.getBiggest(faces);
        this.recogniser.train(AnnotatedObject.create(face, person));
        return face;
    }

    public FACE train(FACE face, PERSON person) {
        this.recogniser.train(AnnotatedObject.create(face, person));
        return face;
    }

    public List<IndependentPair<FACE, List<ScoredAnnotation<PERSON>>>> recognise(FImage image) {
        List<FACE> detectedFaces = this.detector.detectFaces(image);
        ArrayList<IndependentPair<FACE, List<ScoredAnnotation<PERSON>>>> results = new ArrayList<IndependentPair<FACE, List<ScoredAnnotation<PERSON>>>>();
        for (DetectedFace df : detectedFaces) {
            results.add(new IndependentPair((Object)df, this.recogniser.annotate(df)));
        }
        return results;
    }

    public List<IndependentPair<FACE, ScoredAnnotation<PERSON>>> recogniseBest(FImage image) {
        List<FACE> detectedFaces = this.detector.detectFaces(image);
        ArrayList<IndependentPair<FACE, ScoredAnnotation<PERSON>>> results = new ArrayList<IndependentPair<FACE, ScoredAnnotation<PERSON>>>();
        for (DetectedFace df : detectedFaces) {
            results.add(new IndependentPair((Object)df, this.recogniser.annotateBest(df)));
        }
        return results;
    }

    public List<IndependentPair<FACE, List<ScoredAnnotation<PERSON>>>> recognise(FImage image, Set<PERSON> restrict) {
        List<FACE> detectedFaces = this.detector.detectFaces(image);
        ArrayList<IndependentPair<FACE, List<ScoredAnnotation<PERSON>>>> results = new ArrayList<IndependentPair<FACE, List<ScoredAnnotation<PERSON>>>>();
        for (DetectedFace df : detectedFaces) {
            results.add(new IndependentPair((Object)df, this.recogniser.annotate(df, restrict)));
        }
        return results;
    }

    public List<IndependentPair<FACE, ScoredAnnotation<PERSON>>> recogniseBest(FImage image, Set<PERSON> restrict) {
        List<FACE> detectedFaces = this.detector.detectFaces(image);
        ArrayList<IndependentPair<FACE, ScoredAnnotation<PERSON>>> results = new ArrayList<IndependentPair<FACE, ScoredAnnotation<PERSON>>>();
        for (DetectedFace df : detectedFaces) {
            results.add(new IndependentPair((Object)df, this.recogniser.annotateBest(df, restrict)));
        }
        return results;
    }

    public void readBinary(DataInput in) throws IOException {
        String detectorClass = in.readUTF();
        this.detector = (FaceDetector)IOUtils.newInstance((String)detectorClass);
        this.detector.readBinary(in);
        String recogniserClass = in.readUTF();
        this.recogniser = (FaceRecogniser)IOUtils.newInstance((String)recogniserClass);
        this.recogniser.readBinary(in);
    }

    public byte[] binaryHeader() {
        return "FaRE".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeUTF(this.detector.getClass().getName());
        this.detector.writeBinary(out);
        out.writeUTF(((Object)this.recogniser).getClass().getName());
        this.recogniser.writeBinary(out);
    }
}

