/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.recognition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.recognition.FaceRecogniser;
import org.openimaj.io.IOUtils;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.IncrementalAnnotator;
import org.openimaj.ml.annotation.RestrictedAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;

public class AnnotatorFaceRecogniser<FACE extends DetectedFace, PERSON>
extends FaceRecogniser<FACE, PERSON> {
    protected IncrementalAnnotator<FACE, PERSON> annotator;

    protected AnnotatorFaceRecogniser() {
    }

    public AnnotatorFaceRecogniser(IncrementalAnnotator<FACE, PERSON> annotator) {
        this.annotator = annotator;
    }

    public static <FACE extends DetectedFace, EXTRACTOR extends FeatureExtractor<?, FACE>, PERSON> AnnotatorFaceRecogniser<FACE, PERSON> create(IncrementalAnnotator<FACE, PERSON> annotator) {
        return new AnnotatorFaceRecogniser<FACE, PERSON>(annotator);
    }

    public void readBinary(DataInput in) throws IOException {
        this.annotator = (IncrementalAnnotator)IOUtils.read((DataInput)in);
    }

    public byte[] binaryHeader() {
        return "FREC".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        IOUtils.write(this.annotator, (DataOutput)out);
    }

    @Override
    public List<ScoredAnnotation<PERSON>> annotate(FACE object, Collection<PERSON> restrict) {
        if (this.annotator instanceof RestrictedAnnotator) {
            return ((RestrictedAnnotator)this.annotator).annotate(object, restrict);
        }
        List pot = this.annotator.annotate(object);
        if (pot == null || pot.size() == 0) {
            return null;
        }
        ArrayList<ScoredAnnotation<PERSON>> toKeep = new ArrayList<ScoredAnnotation<PERSON>>();
        for (ScoredAnnotation p : pot) {
            if (!restrict.contains(p.annotation)) continue;
            toKeep.add(p);
        }
        return toKeep;
    }

    @Override
    public List<ScoredAnnotation<PERSON>> annotate(FACE object) {
        return this.annotator.annotate(object);
    }

    public void train(Annotated<FACE, PERSON> annotedImage) {
        this.annotator.train(annotedImage);
    }

    public void train(Iterable<? extends Annotated<FACE, PERSON>> data) {
        this.annotator.train(data);
    }

    public Set<PERSON> getAnnotations() {
        return this.annotator.getAnnotations();
    }

    public void reset() {
        this.annotator.reset();
    }

    public String toString() {
        return String.format("AnnotatorFaceRecogniser[recogniser=%s]", this.annotator);
    }
}

