/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public class DetectedFace
implements ReadWriteableBinary {
    protected Rectangle bounds;
    protected FImage facePatch;
    protected float confidence = 1.0f;

    public DetectedFace() {
        this.bounds = new Rectangle();
    }

    public DetectedFace(Rectangle bounds, FImage patch, float confidence) {
        this.bounds = bounds;
        this.facePatch = patch;
        this.confidence = confidence;
    }

    public FImage getFacePatch() {
        return this.facePatch;
    }

    public void setFacePatch(FImage img) {
        this.facePatch = img;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rect) {
        this.bounds = rect;
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.bounds.writeBinary(out);
        ImageUtilities.write((Image)this.facePatch, (String)"png", (DataOutput)out);
    }

    public byte[] binaryHeader() {
        return "DF".getBytes();
    }

    public void readBinary(DataInput in) throws IOException {
        this.bounds.readBinary(in);
        this.facePatch = ImageUtilities.readF((DataInput)in);
    }

    public float getConfidence() {
        return this.confidence;
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void setConfidence(int confidence) {
        this.confidence = confidence;
    }
}

