/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import Jama.Matrix;
import com.jsaragih.CLM;
import com.jsaragih.FDet;
import com.jsaragih.IO;
import com.jsaragih.MFCheck;
import com.jsaragih.Tracker;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.face.detection.CLMDetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.io.IOUtils;
import org.openimaj.math.geometry.shape.Rectangle;

@Reference(type=ReferenceType.Inproceedings, author={"Jason M. Saragih", "Simon Lucey", "Jeffrey F. Cohn"}, title="Face alignment through subspace constrained mean-shifts", year="2009", booktitle="IEEE 12th International Conference on Computer Vision, ICCV 2009, Kyoto, Japan, September 27 - October 4, 2009", pages={"1034", "1041"}, publisher="IEEE", customData={"doi", "http://dx.doi.org/10.1109/ICCV.2009.5459377", "researchr", "http://researchr.org/publication/SaragihLC09", "cites", "0", "citedby", "0"})
public class CLMFaceDetector
implements FaceDetector<CLMDetectedFace, FImage> {
    private Configuration config = new Configuration();

    public void readBinary(DataInput in) throws IOException {
        this.config = (Configuration)IOUtils.read((DataInput)in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        IOUtils.write((Object)this.config, (DataOutput)out);
    }

    @Override
    public List<CLMDetectedFace> detectFaces(FImage image) {
        List detRects = this.config.faceDetector.detect(image);
        return this.detectFaces(image, detRects);
    }

    public List<CLMDetectedFace> detectFaces(FImage image, List<Rectangle> detRects) {
        ArrayList<CLMDetectedFace> faces = new ArrayList<CLMDetectedFace>();
        for (Rectangle f : detRects) {
            if (f.width == 0.0f || f.height == 0.0f) continue;
            this.initShape(f, this.config.shape, this.config.referenceShape);
            this.config.clm._pdm.calcParams(this.config.shape, this.config.clm._plocal, this.config.clm._pglobl);
            this.config.clm.fit(image, this.config.windowSize, this.config.nIter, this.config.clamp, this.config.fTol);
            this.config.clm._pdm.calcShape2D(this.config.shape, this.config.clm._plocal, this.config.clm._pglobl);
            if (this.config.fcheck && !this.config.failureCheck.check(this.config.clm.getViewIdx(), image, this.config.shape)) continue;
            faces.add(new CLMDetectedFace(f, this.config.shape.copy(), this.config.clm._pglobl.copy(), this.config.clm._plocal.copy(), this.config.clm._visi[this.config.clm.getViewIdx()].copy(), image));
        }
        return faces;
    }

    private void initShape(Rectangle r, Matrix shape, Matrix _rshape) {
        assert (shape.getRowDimension() == _rshape.getRowDimension() && shape.getColumnDimension() == _rshape.getColumnDimension());
        int n = _rshape.getRowDimension() / 2;
        double a = (double)r.width * Math.cos(this.config.similarity[1]) * this.config.similarity[0] + 1.0;
        double b = (double)r.width * Math.sin(this.config.similarity[1]) * this.config.similarity[0];
        double tx = (double)(r.x + (float)((int)(r.width / 2.0f))) + (double)r.width * this.config.similarity[2];
        double ty = (double)(r.y + (float)((int)(r.height / 2.0f))) + (double)r.height * this.config.similarity[3];
        double[][] s = _rshape.getArray();
        double[][] d = shape.getArray();
        for (int i = 0; i < n; ++i) {
            d[i][0] = a * s[i][0] - b * s[i + n][0] + tx;
            d[i + n][0] = b * s[i][0] + a * s[i + n][0] + ty;
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public static class Configuration {
        public CLM clm;
        public Matrix referenceShape;
        public Matrix shape;
        public FDet faceDetector;
        public MFCheck failureCheck;
        double[] similarity;
        public int[][] triangles = null;
        public int[][] connections = null;
        public boolean fcheck = false;
        public int[] windowSize = new int[]{11, 9, 7};
        public int nIter = 5;
        public double clamp = 3.0;
        public double fTol = 0.01;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void read(InputStream in) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(in));
                Scanner sc = new Scanner(br);
                this.read(sc, true);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void read(Scanner s, boolean readType) {
            if (readType) {
                int type = s.nextInt();
                assert (type == IO.Types.TRACKER.ordinal());
            }
            this.clm = CLM.read((Scanner)s, (boolean)true);
            this.faceDetector = FDet.read((Scanner)s, (boolean)true);
            this.failureCheck = MFCheck.read((Scanner)s, (boolean)true);
            this.referenceShape = IO.readMat((Scanner)s);
            this.similarity = new double[]{s.nextDouble(), s.nextDouble(), s.nextDouble(), s.nextDouble()};
            this.shape = new Matrix(2 * this.clm._pdm.nPoints(), 1);
            this.clm._pdm.identity(this.clm._plocal, this.clm._pglobl);
        }

        public Configuration() {
            this.read(Tracker.class.getResourceAsStream("face2.tracker"));
            this.triangles = IO.loadTri((InputStream)Tracker.class.getResourceAsStream("face.tri"));
            this.connections = IO.loadCon((InputStream)Tracker.class.getResourceAsStream("face.con"));
        }
    }
}

