/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.alignment;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.detection.CLMDetectedFace;
import org.openimaj.image.processing.face.detection.CLMFaceDetector;
import org.openimaj.image.processing.face.tracking.clm.CLMFaceTracker;
import org.openimaj.image.processing.transform.PiecewiseMeshWarp;
import org.openimaj.io.IOUtils;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.shape.Triangle;
import org.openimaj.util.pair.Pair;

public class CLMAligner
implements FaceAligner<CLMDetectedFace> {
    private CLMFaceDetector.Configuration config;
    private int size = 100;
    private transient List<Triangle> referenceTriangles;
    private transient FImage mask;

    public CLMAligner() {
        this.config = new CLMFaceDetector.Configuration();
        this.loadReference();
    }

    public CLMAligner(int size) {
        this.size = size;
        this.config = new CLMFaceDetector.Configuration();
        this.loadReference();
    }

    private void loadReference() {
        this.referenceTriangles = CLMFaceTracker.getTriangles(this.config.referenceShape, null, this.config.triangles);
        this.mask = new FImage(this.size, this.size);
        for (Triangle t : this.referenceTriangles) {
            t.scale(0.3f * (float)this.size);
            t.translate(0.5f * (float)this.size, 0.45f * (float)this.size);
            this.mask.drawShapeFilled((Shape)t, (Object)Float.valueOf(1.0f));
        }
    }

    public void readBinary(DataInput in) throws IOException {
        this.config = (CLMFaceDetector.Configuration)IOUtils.read((DataInput)in);
        this.loadReference();
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        IOUtils.write((Object)this.config, (DataOutput)out);
    }

    @Override
    public FImage align(CLMDetectedFace face) {
        if (face == null) {
            return null;
        }
        List<Triangle> triangles = CLMFaceTracker.getTriangles(face.getShapeMatrix(), face.getVisibility(), this.config.triangles);
        List<Pair<Shape>> matches = this.computeMatches(triangles);
        PiecewiseMeshWarp pmw = new PiecewiseMeshWarp(matches);
        return (FImage)pmw.transform((Image)face.getFacePatch(), this.size, this.size);
    }

    @Override
    public FImage getMask() {
        return this.mask;
    }

    private List<Pair<Shape>> computeMatches(List<Triangle> triangles) {
        ArrayList<Pair<Shape>> mtris = new ArrayList<Pair<Shape>>();
        for (int i = 0; i < triangles.size(); ++i) {
            Triangle t1 = triangles.get(i);
            Triangle t2 = this.referenceTriangles.get(i);
            if (t1 == null || t2 == null) continue;
            mtris.add((Pair<Shape>)new Pair((Object)t1, (Object)t2));
        }
        return mtris;
    }
}

