/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.set;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class BoundedTreeSet<T>
extends TreeSet<T> {
    private static final long serialVersionUID = 1L;
    protected int maxSize;

    public BoundedTreeSet(int maxSize) {
        this.maxSize = maxSize;
    }

    public BoundedTreeSet(int maxSize, Comparator<? super T> comparator) {
        super(comparator);
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(T e) {
        if (this.contains(e)) {
            return false;
        }
        if (this.size() < this.maxSize) {
            return super.add(e);
        }
        Object last = this.last();
        if (this.comparator() == null) {
            Comparable key = (Comparable)last;
            if (key.compareTo(e) > 0) {
                this.remove(last);
                return super.add(e);
            }
        } else if (this.comparator().compare(last, e) > 0) {
            this.remove(last);
            return super.add(e);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T e : c) {
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }
}

