/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.reflection;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFinder {
    public static List<Class<?>> findClasses(Package pkg) throws IOException {
        return ClassFinder.findClasses(pkg.getName());
    }

    public static List<Class<?>> findClasses(String packageName) throws IOException {
        ArrayList classes = new ArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (resource.getProtocol().equals("file")) {
                classes.addAll(ClassFinder.findClassesInDir(new File(resource.getFile()), packageName));
                continue;
            }
            if (!resource.getProtocol().equals("jar")) continue;
            String rf = resource.getFile();
            File file = new File(rf.substring(5, rf.indexOf("!")));
            classes.addAll(ClassFinder.findClassesInJar(file, packageName));
        }
        return classes;
    }

    public static List<Class<?>> findClassesInDir(File directory, String packageName) {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(ClassFinder.findClassesInDir(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            try {
                classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<?>> findClassesInJar(File jarFile, String packageName) throws IOException {
        ArrayList classes = new ArrayList();
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> enu = jar.entries();
            String path = packageName.replace(".", "/");
            while (enu.hasMoreElements()) {
                JarEntry je = enu.nextElement();
                String name = je.getName();
                if (!name.startsWith(path) || !name.endsWith(".class")) continue;
                try {
                    classes.add(Class.forName(name.replace("/", ".").substring(0, name.length() - 6)));
                }
                catch (ClassNotFoundException e) {}
            }
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {}
            }
        }
        return classes;
    }
}

