/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.iterator;

import java.util.Iterator;
import org.openimaj.util.iterator.NumericIterable;

public class UniformIntRangeIterable
implements NumericIterable<Integer> {
    private int stop;
    private int step;
    private int current;

    public UniformIntRangeIterable(int start, int stop, int step) {
        this.stop = stop;
        this.step = step;
        this.current = start;
    }

    public UniformIntRangeIterable(int start, int stop) {
        this(start, stop, 1);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){

            @Override
            public boolean hasNext() {
                return UniformIntRangeIterable.this.current + UniformIntRangeIterable.this.step <= UniformIntRangeIterable.this.stop;
            }

            @Override
            public Integer next() {
                int ret = UniformIntRangeIterable.this.current;
                UniformIntRangeIterable.this.current += UniformIntRangeIterable.this.step;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

