/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;
import org.openimaj.util.concatenate.Concatenatable;

public abstract class SparseLongArray
implements ReadWriteable,
Concatenatable<SparseLongArray, SparseLongArray> {
    protected static final int DEFAULT_CAPACITY = 10;
    public int length;

    public abstract long increment(int var1, long var2);

    public abstract int[] indices();

    public abstract long[] values();

    public abstract Iterable<Entry> entries();

    public Iterable<DualEntry> unionEntries(final SparseLongArray otherArray) {
        return new Iterable<DualEntry>(){

            @Override
            public Iterator<DualEntry> iterator() {
                final TIntHashSet keys = new TIntHashSet(SparseLongArray.this.indices());
                keys.addAll(otherArray.indices());
                return new Iterator<DualEntry>(){
                    DualEntry entry = new DualEntry();
                    TIntIterator iterator = keys.iterator();

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public DualEntry next() {
                        this.entry.index = this.iterator.next();
                        this.entry.value = SparseLongArray.this.get(this.entry.index);
                        this.entry.otherValue = otherArray.get(this.entry.index);
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<DualEntry> intersectEntries(final SparseLongArray otherArray) {
        return new Iterable<DualEntry>(){

            @Override
            public Iterator<DualEntry> iterator() {
                TIntHashSet keys;
                if (SparseLongArray.this.used() < otherArray.used()) {
                    keys = new TIntHashSet(SparseLongArray.this.indices());
                    keys.retainAll(otherArray.indices());
                } else {
                    keys = new TIntHashSet(otherArray.indices());
                    keys.retainAll(SparseLongArray.this.indices());
                }
                return new Iterator<DualEntry>(){
                    DualEntry entry = new DualEntry();
                    TIntIterator iterator = keys.iterator();

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public DualEntry next() {
                        this.entry.index = this.iterator.next();
                        this.entry.value = SparseLongArray.this.get(this.entry.index);
                        this.entry.otherValue = otherArray.get(this.entry.index);
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public abstract long get(int var1);

    public abstract boolean isUsed(int var1);

    public abstract long set(int var1, long var2);

    public void setLength(int newLength) {
        if (newLength < this.length) {
            throw new IllegalArgumentException("can't make sparse array shorter");
        }
        this.length = newLength;
    }

    public int size() {
        return this.length;
    }

    public int length() {
        return this.length;
    }

    public abstract int used();

    public float density() {
        return (float)this.used() / (float)this.length;
    }

    public abstract void compact();

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.length);
        out.print(" ");
        for (Entry e : this.entries()) {
            out.print(e.index + ":" + e.value + " ");
        }
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        String[] parts;
        this.length = in.nextInt();
        for (String part : parts = in.nextLine().split(" ")) {
            String[] bits = part.split(":");
            this.set(Integer.parseInt(bits[0]), Long.parseLong(bits[1]));
        }
    }

    @Override
    public String asciiHeader() {
        return "SpLongA";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.writeInt(this.used());
        for (Entry e : this.entries()) {
            out.writeInt(e.index);
            out.writeLong(e.value);
        }
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.length = in.readInt();
        int used = in.readInt();
        for (int i = 0; i < used; ++i) {
            this.set(in.readInt(), in.readLong());
        }
    }

    @Override
    public byte[] binaryHeader() {
        return "SpLongA".getBytes();
    }

    public abstract SparseLongArray copy();

    public SparseLongArray add(SparseLongArray vector) {
        return this.copy().addInplace(vector);
    }

    public SparseLongArray addInplace(SparseLongArray vector) {
        for (Entry e : this.entries()) {
            this.increment(e.index, e.value);
        }
        return this;
    }

    public SparseLongArray subtract(SparseLongArray vector) {
        return this.copy().subtractInplace(vector);
    }

    public SparseLongArray subtractInplace(SparseLongArray vector) {
        for (Entry e : this.entries()) {
            this.increment(e.index, -e.value);
        }
        return this;
    }

    public SparseLongArray multiply(double value) {
        return this.copy().multiplyInplace(value);
    }

    public SparseLongArray multiplyInplace(double value) {
        for (Entry e : this.entries()) {
            if (!this.isUsed(e.index)) continue;
            this.set(e.index, this.get(e.index) * e.value);
        }
        return this;
    }

    public double dotProduct(SparseLongArray vector) {
        int vused;
        double sum = 0.0;
        int tused = this.used();
        SparseLongArray smaller = tused < (vused = vector.used()) ? this : vector;
        SparseLongArray larger = tused < vused ? vector : this;
        for (Entry e : smaller.entries()) {
            sum += (double)(e.value * larger.get(e.index));
        }
        return sum;
    }

    public long maxValue() {
        long max = -9223372036854775807L;
        for (Entry e : this.entries()) {
            if (e.value <= max) continue;
            max = e.value;
        }
        return max;
    }

    public long minValue() {
        long min = Long.MAX_VALUE;
        for (Entry e : this.entries()) {
            if (e.value >= min) continue;
            min = e.value;
        }
        return min;
    }

    public int maxIndex() {
        long max = -9223372036854775807L;
        int index = 0;
        for (Entry e : this.entries()) {
            if (e.value <= max) continue;
            max = e.value;
            index = e.index;
        }
        return index;
    }

    public int minIndex() {
        long min = Long.MAX_VALUE;
        int index = 0;
        for (Entry e : this.entries()) {
            if (e.value >= min) continue;
            min = e.value;
            index = e.index;
        }
        return index;
    }

    public abstract SparseLongArray reverse();

    public static SparseLongArray concatenateArrays(SparseLongArray ... arrays) {
        SparseLongArray concat = arrays[0].copy();
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i] == null) continue;
            int oldLength = concat.length;
            concat.setLength(oldLength + arrays[i].length);
            for (Entry e : arrays[i].entries()) {
                concat.set(e.index + oldLength, e.value);
            }
        }
        return concat;
    }

    public long sumValues() {
        long sum = 0L;
        for (Entry e : this.entries()) {
            sum += e.value;
        }
        return sum;
    }

    public long sumValuesSquared() {
        long sum = 0L;
        for (Entry e : this.entries()) {
            sum += e.value * e.value;
        }
        return sum;
    }

    public long[] toArray() {
        long[] array = new long[this.length];
        for (Entry e : this.entries()) {
            array[e.index] = e.value;
        }
        return array;
    }

    public long[] toArray(long[] array) {
        if (array == null || array.length < this.length) {
            array = new long[this.length];
        } else {
            Arrays.fill(array, 0L);
        }
        for (Entry e : this.entries()) {
            array[e.index] = e.value;
        }
        return array;
    }

    public SparseLongArray concatenate(SparseLongArray ... ins) {
        SparseLongArray result = this.copy();
        for (int i = 0; i < ins.length; ++i) {
            int oldLength = result.length;
            result.setLength(oldLength + ins[i].length);
            for (Entry e : ins[i].entries()) {
                result.set(e.index + oldLength, e.value);
            }
        }
        return result;
    }

    @Override
    public SparseLongArray concatenate(List<SparseLongArray> ins) {
        SparseLongArray result = this.copy();
        for (int i = 0; i < ins.size(); ++i) {
            int oldLength = result.length;
            result.setLength(oldLength + ins.get((int)i).length);
            for (Entry e : ins.get(i).entries()) {
                result.set(e.index + oldLength, e.value);
            }
        }
        return result;
    }

    public static class DualEntry
    extends Entry {
        public long otherValue;
    }

    public static class Entry {
        public int index;
        public long value;
    }
}

