/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.openimaj.io.WriteableBinary;

public abstract class WriteableListBinary<V>
implements WriteableBinary {
    public List<V> value;

    public WriteableListBinary(List<V> list) {
        this.value = list;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.value.size());
        for (V v : this.value) {
            this.writeValue(v, out);
        }
    }

    protected abstract void writeValue(V var1, DataOutput var2) throws IOException;

    @Override
    public byte[] binaryHeader() {
        return this.value.getClass().getName().getBytes();
    }
}

