/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data.dataset;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.util.iterator.ConcatenatedIterable;

public class MapBackedDataset<KEY, DATASET extends Dataset<INSTANCE>, INSTANCE>
extends AbstractMap<KEY, DATASET>
implements GroupedDataset<KEY, DATASET, INSTANCE> {
    protected Map<KEY, DATASET> map;

    public MapBackedDataset() {
        this.map = new HashMap<KEY, DATASET>();
    }

    public MapBackedDataset(Map<KEY, DATASET> map) {
        this.map = map;
    }

    public Map<KEY, DATASET> getMap() {
        return this.map;
    }

    @Override
    public DATASET getInstances(KEY key) {
        return (DATASET)((Dataset)this.map.get(key));
    }

    @Override
    public Set<KEY> getGroups() {
        return this.map.keySet();
    }

    @Override
    public INSTANCE getRandomInstance(KEY key) {
        return ((Dataset)this.map.get(key)).getRandomInstance();
    }

    @Override
    public INSTANCE getRandomInstance() {
        int index = (int)(Math.random() * (double)this.numInstances());
        int count = 0;
        for (Dataset d : this.map.values()) {
            if (index >= count + d.numInstances()) {
                count += d.numInstances();
                continue;
            }
            if (d instanceof ListDataset) {
                return (INSTANCE)((ListDataset)d).get(index - count);
            }
            for (Object i : d) {
                if (index == count) {
                    return (INSTANCE)i;
                }
                ++count;
            }
        }
        return null;
    }

    @Override
    public int numInstances() {
        int size = 0;
        for (Dataset d : this.map.values()) {
            size += d.numInstances();
        }
        return size;
    }

    @Override
    public Iterator<INSTANCE> iterator() {
        return new ConcatenatedIterable(this.map.values()).iterator();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public Set<Map.Entry<KEY, DATASET>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public DATASET put(KEY key, DATASET value) {
        return (DATASET)((Dataset)this.map.put(key, value));
    }

    public MapBackedDataset<KEY, DATASET, INSTANCE> add(KEY key, DATASET dataset) {
        this.put(key, dataset);
        return this;
    }

    public static <INSTANCE, DATASET extends Dataset<INSTANCE> & Identifiable> MapBackedDataset<String, DATASET, INSTANCE> of(DATASET ... datasets) {
        MapBackedDataset<String, DATASET, INSTANCE> ds = new MapBackedDataset<String, DATASET, INSTANCE>();
        for (DATASET d : datasets) {
            ds.put(((Identifiable)d).getID(), d);
        }
        return ds;
    }

    public static <DATASET extends Dataset<INSTANCE> & Identifiable, INSTANCE> IdentifiableBuilder<DATASET, INSTANCE> builder() {
        return new IdentifiableBuilder();
    }

    public static <INSTANCE, DATASET extends Dataset<INSTANCE> & Identifiable> MapBackedDataset<String, DATASET, INSTANCE> of(DATASET d1) {
        MapBackedDataset<String, DATASET, INSTANCE> ds = new MapBackedDataset<String, DATASET, INSTANCE>();
        ds.put(((Identifiable)d1).getID(), d1);
        return ds;
    }

    public static <INSTANCE, DATASET extends Dataset<INSTANCE> & Identifiable> MapBackedDataset<String, DATASET, INSTANCE> of(DATASET d1, DATASET d2) {
        MapBackedDataset<String, DATASET, INSTANCE> ds = new MapBackedDataset<String, DATASET, INSTANCE>();
        ds.put(((Identifiable)d1).getID(), d1);
        ds.put(((Identifiable)d2).getID(), d2);
        return ds;
    }

    public static <INSTANCE, DATASET extends Dataset<INSTANCE> & Identifiable> MapBackedDataset<String, DATASET, INSTANCE> of(DATASET d1, DATASET d2, DATASET d3) {
        MapBackedDataset<String, DATASET, INSTANCE> ds = new MapBackedDataset<String, DATASET, INSTANCE>();
        ds.put(((Identifiable)d1).getID(), d1);
        ds.put(((Identifiable)d2).getID(), d2);
        ds.put(((Identifiable)d3).getID(), d3);
        return ds;
    }

    public static <INSTANCE, DATASET extends Dataset<INSTANCE> & Identifiable> MapBackedDataset<String, DATASET, INSTANCE> of(DATASET d1, DATASET d2, DATASET d3, DATASET d4) {
        MapBackedDataset<String, DATASET, INSTANCE> ds = new MapBackedDataset<String, DATASET, INSTANCE>();
        ds.put(((Identifiable)d1).getID(), d1);
        ds.put(((Identifiable)d2).getID(), d2);
        ds.put(((Identifiable)d3).getID(), d3);
        ds.put(((Identifiable)d4).getID(), d4);
        return ds;
    }

    public static <INSTANCE, DATASET extends Dataset<INSTANCE> & Identifiable> MapBackedDataset<String, DATASET, INSTANCE> of(DATASET d1, DATASET d2, DATASET d3, DATASET d4, DATASET d5) {
        MapBackedDataset<String, DATASET, INSTANCE> ds = new MapBackedDataset<String, DATASET, INSTANCE>();
        ds.put(((Identifiable)d1).getID(), d1);
        ds.put(((Identifiable)d2).getID(), d2);
        ds.put(((Identifiable)d3).getID(), d3);
        ds.put(((Identifiable)d4).getID(), d4);
        ds.put(((Identifiable)d5).getID(), d5);
        return ds;
    }

    public static <INSTANCE, DATASET extends Dataset<INSTANCE> & Identifiable> MapBackedDataset<String, DATASET, INSTANCE> of(Collection<DATASET> datasets) {
        MapBackedDataset<String, Dataset, INSTANCE> ds = new MapBackedDataset<String, Dataset, INSTANCE>();
        for (Dataset d : datasets) {
            ds.put(((Identifiable)((Object)d)).getID(), d);
        }
        return ds;
    }

    public static class IdentifiableBuilder<DATASET extends Dataset<INSTANCE> & Identifiable, INSTANCE> {
        MapBackedDataset<String, DATASET, INSTANCE> ds = new MapBackedDataset();

        public IdentifiableBuilder<DATASET, INSTANCE> add(DATASET dataset) {
            this.ds.put(((Identifiable)dataset).getID(), dataset);
            return this;
        }

        public MapBackedDataset<String, DATASET, INSTANCE> build() {
            return new MapBackedDataset(this.ds);
        }
    }
}

