/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Date;
import java.util.Random;

public class RandomData {
    public static float[][] getRandomFloatArray(int rows, int cols, float min, float max) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        float[][] data = new float[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextFloatFromTo(min, max);
            }
        }
        return data;
    }

    public static float[][] getRandomFloatArray(int rows, int cols, float min, float max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        float[][] data = new float[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextFloatFromTo(min, max);
            }
        }
        return data;
    }

    public static double[][] getRandomDoubleArray(int rows, int cols, double min, double max) {
        Uniform rnd = new Uniform(min, max, (RandomEngine)new MersenneTwister(new Date()));
        double[][] data = new double[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextDoubleFromTo(min, max);
            }
        }
        return data;
    }

    public static double[][] getRandomDoubleArray(int rows, int cols, double min, double max, int seed) {
        Uniform rnd = new Uniform(min, max, (RandomEngine)new MersenneTwister(seed));
        double[][] data = new double[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextDoubleFromTo(min, max);
            }
        }
        return data;
    }

    public static int[][] getRandomIntArray(int rows, int cols, int min, int max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        int[][] data = new int[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextIntFromTo(min, max);
            }
        }
        return data;
    }

    public static long[][] getRandomLongArray(int rows, int cols, long min, long max) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        long[][] data = new long[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextLongFromTo(min, max);
            }
        }
        return data;
    }

    public static long[][] getRandomLongArray(int rows, int cols, long min, long max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        long[][] data = new long[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = rnd.nextLongFromTo(min, max);
            }
        }
        return data;
    }

    public static short[][] getRandomShortArray(int rows, int cols, short min, short max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        short[][] data = new short[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = (short)rnd.nextIntFromTo((int)min, (int)max);
            }
        }
        return data;
    }

    public static byte[][] getRandomByteArray(int rows, int cols, byte min, byte max) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        byte[][] data = new byte[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = (byte)rnd.nextIntFromTo((int)min, (int)max);
            }
        }
        return data;
    }

    public static byte[][] getRandomByteArray(int rows, int cols, byte min, byte max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        byte[][] data = new byte[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                data[r][c] = (byte)rnd.nextIntFromTo((int)min, (int)max);
            }
        }
        return data;
    }

    public static int[] getUniqueRandomIntsA(int N, int min, int max) {
        return RandomData.getUniqueRandomIntsA(N, min, max, new Random());
    }

    public static int[] getUniqueRandomIntsS(int N, int min, int max) {
        return RandomData.getUniqueRandomIntsS(N, min, max, new Random());
    }

    public static int[] getUniqueRandomInts(int N, int min, int max) {
        return RandomData.getUniqueRandomInts(N, min, max, new Random());
    }

    public static int[] getUniqueRandomIntsA(int N, int min, int max, Random rnd) {
        int rng = max - min;
        if (rng < N) {
            throw new IllegalArgumentException("Cannot generate more random numbers than the range allows");
        }
        TIntArrayList allData = new TIntArrayList(rng);
        for (int i = min; i < max; ++i) {
            allData.add(i);
        }
        allData.shuffle(rnd);
        int[] data = new int[N];
        allData.toArray(data, 0, N);
        return data;
    }

    public static int[] getUniqueRandomIntsS(int N, int min, int max, Random rnd) {
        int rng = max - min;
        if (rng < N) {
            throw new IllegalArgumentException("Cannot generate more random numbers than the range allows");
        }
        TIntHashSet set = new TIntHashSet(N);
        for (int i = 0; i < N; ++i) {
            int r;
            while (set.contains(r = rnd.nextInt(rng) + min)) {
            }
            set.add(r);
        }
        return set.toArray();
    }

    public static int[] getUniqueRandomInts(int N, int min, int max, Random rng) {
        if ((double)N / (double)(max - min) > 0.4) {
            return RandomData.getUniqueRandomIntsA(N, min, max, rng);
        }
        return RandomData.getUniqueRandomIntsS(N, min, max, rng);
    }

    public static float[] getRandomFloatArray(int length, float min, float max) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        float[] data = new float[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextFloatFromTo(min, max);
        }
        return data;
    }

    public static float[] getRandomFloatArray(int length, float min, float max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        float[] data = new float[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextFloatFromTo(min, max);
        }
        return data;
    }

    public static double[] getRandomDoubleArray(int length, double min, double max) {
        Uniform rnd = new Uniform(min, max, (RandomEngine)new MersenneTwister(new Date()));
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextDoubleFromTo(min, max);
        }
        return data;
    }

    public static double[] getRandomDoubleArray(int length, double min, double max, int seed) {
        Uniform rnd = new Uniform(min, max, (RandomEngine)new MersenneTwister(seed));
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextDoubleFromTo(min, max);
        }
        return data;
    }

    public static int[] getRandomIntArray(int length, int min, int max) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextIntFromTo(min, max);
        }
        return data;
    }

    public static int[] getRandomIntArray(int length, int min, int max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextIntFromTo(min, max);
        }
        return data;
    }

    public static long[] getRandomLongArray(int length, long min, long max) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextLongFromTo(min, max);
        }
        return data;
    }

    public static long[] getRandomLongArray(int length, long min, long max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextLongFromTo(min, max);
        }
        return data;
    }

    public static short[] getRandomShortArray(int length, short min, short max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        short[] data = new short[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (short)rnd.nextIntFromTo((int)min, (int)max);
        }
        return data;
    }

    public static byte[] getRandomByteArray(int length, byte min, byte max) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(new Date()));
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)rnd.nextIntFromTo((int)min, (int)max);
        }
        return data;
    }

    public static byte[] getRandomByteArray(int length, byte min, byte max, int seed) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)new MersenneTwister(seed));
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)rnd.nextIntFromTo((int)min, (int)max);
        }
        return data;
    }

    public static float[] getRandomFloatArray(int length, float min, float max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)mt);
        float[] data = new float[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextFloatFromTo(min, max);
        }
        return data;
    }

    public static double[] getRandomDoubleArray(int length, double min, double max, MersenneTwister mt) {
        Uniform rnd = new Uniform(min, max, (RandomEngine)mt);
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextDoubleFromTo(min, max);
        }
        return data;
    }

    public static int[] getRandomIntArray(int length, int min, int max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)mt);
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextIntFromTo(min, max);
        }
        return data;
    }

    public static long[] getRandomLongArray(int length, long min, long max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)mt);
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rnd.nextLongFromTo(min, max);
        }
        return data;
    }

    public static short[] getRandomShortArray(int length, short min, short max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)mt);
        short[] data = new short[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (short)rnd.nextIntFromTo((int)min, (int)max);
        }
        return data;
    }

    public static byte[] getRandomByteArray(int length, byte min, byte max, MersenneTwister mt) {
        Uniform rnd = new Uniform((double)min, (double)max, (RandomEngine)mt);
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)rnd.nextIntFromTo((int)min, (int)max);
        }
        return data;
    }
}

