/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import java.util.Iterator;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.data.RandomData;
import org.openimaj.util.array.ArrayIterator;

public class LongArrayBackedDataSource
implements DataSource<long[]> {
    protected long[][] data;
    protected Random rng;

    public LongArrayBackedDataSource(long[][] data) {
        this.data = data;
        this.rng = new Random();
    }

    public LongArrayBackedDataSource(long[][] data, Random rng) {
        this.data = data;
        this.rng = rng;
    }

    public final void getData(int startRow, int stopRow, long[][] output) {
        int i = startRow;
        int j = 0;
        while (i < stopRow) {
            System.arraycopy(this.data[i], 0, output[j], 0, this.data[i].length);
            ++i;
            ++j;
        }
    }

    public final void getRandomRows(long[][] output) {
        int k = output.length;
        int[] ind = RandomData.getUniqueRandomInts(k, 0, this.data.length, this.rng);
        for (int i = 0; i < k; ++i) {
            System.arraycopy(this.data[ind[i]], 0, output[i], 0, this.data[ind[i]].length);
        }
    }

    @Override
    public int numDimensions() {
        return this.data[0].length;
    }

    @Override
    public int numRows() {
        return this.data.length;
    }

    @Override
    public long[] getData(int row) {
        return this.data[row];
    }

    @Override
    public Iterator<long[]> iterator() {
        return new ArrayIterator<long[]>((T[])this.data);
    }
}

