/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.model.fit;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.math.model.fit.residuals.ResidualCalculator;
import org.openimaj.math.util.distance.DistanceCheck;
import org.openimaj.math.util.distance.ThresholdDistanceCheck;
import org.openimaj.util.pair.IndependentPair;

public class SimpleModelFitting<I, D, M extends EstimatableModel<I, D>>
implements RobustModelFitting<I, D, M> {
    List<IndependentPair<I, D>> inl;
    List<IndependentPair<I, D>> outl;
    M model;
    ResidualCalculator<I, D, M> errorModel;
    DistanceCheck dc;

    public SimpleModelFitting(M m, ResidualCalculator<I, D, M> errorModel, double errorThreshold) {
        this.model = m;
        this.errorModel = errorModel;
        this.dc = new ThresholdDistanceCheck(errorThreshold);
    }

    public SimpleModelFitting(M m, ResidualCalculator<I, D, M> errorModel, DistanceCheck dc) {
        this.model = m;
        this.errorModel = errorModel;
        this.dc = dc;
    }

    @Override
    public List<? extends IndependentPair<I, D>> getInliers() {
        return this.inl;
    }

    @Override
    public List<? extends IndependentPair<I, D>> getOutliers() {
        return this.outl;
    }

    @Override
    public boolean fitData(List<? extends IndependentPair<I, D>> data) {
        if (!this.model.estimate(data)) {
            return false;
        }
        this.inl = new ArrayList<IndependentPair<I, D>>();
        this.outl = new ArrayList<IndependentPair<I, D>>();
        for (int i = 0; i < data.size(); ++i) {
            if (this.dc.check(this.errorModel.computeResidual(data.get(i)))) {
                this.inl.add(data.get(i));
                continue;
            }
            this.outl.add(data.get(i));
        }
        return true;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public int numItemsToEstimate() {
        return this.model.numItemsToEstimate();
    }
}

