/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms.residuals;

import Jama.Matrix;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.MatrixTransformProvider;
import org.openimaj.math.model.Model;
import org.openimaj.math.model.fit.residuals.ResidualCalculator;
import org.openimaj.util.pair.IndependentPair;

public class SymmetricTransferResidual2d<M extends Model<Point2d, Point2d> & MatrixTransformProvider>
implements ResidualCalculator<Point2d, Point2d, M> {
    private Matrix transform;
    private Matrix transformInv;

    @Override
    public void setModel(M model) {
        this.transform = ((MatrixTransformProvider)model).getTransform();
        if (this.transform.getRowDimension() != 3 || this.transform.getColumnDimension() != 3) {
            throw new IllegalArgumentException("Transform matrix must be 3x3");
        }
        this.transformInv = this.transform.inverse();
    }

    @Override
    public double computeResidual(IndependentPair<Point2d, Point2d> data) {
        Point2d p1 = (Point2d)data.getFirstObject();
        Point2d p2 = (Point2d)data.getSecondObject();
        Point2d p1t = p1.transform(this.transform);
        Point2d p2t = p2.transform(this.transformInv);
        float p1x = p1.getX();
        float p1y = p1.getY();
        float p1tx = p1t.getX();
        float p1ty = p1t.getY();
        float p2x = p2.getX();
        float p2y = p2.getY();
        float p2tx = p2t.getX();
        float p2ty = p2t.getY();
        float dx12t = p1x - p2tx;
        float dy12t = p1y - p2ty;
        float dx1t2 = p1tx - p2x;
        float dy1t2 = p1ty - p2y;
        return dx12t * dx12t + dy12t * dy12t + dx1t2 * dx1t2 + dy1t2 * dy1t2;
    }

    @Override
    public void computeResiduals(List<? extends IndependentPair<Point2d, Point2d>> data, double[] residuals) {
        for (int i = 0; i < data.size(); ++i) {
            residuals[i] = this.computeResidual(data.get(i));
        }
    }
}

