/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.point;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Scanner;
import org.openimaj.math.geometry.point.Coordinate;
import org.openimaj.math.geometry.point.Point2d;

public class Point2dImpl
implements Point2d,
Cloneable {
    public float x;
    public float y;

    public Point2dImpl(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Point2dImpl(Point2d p) {
        this.copyFrom(p);
    }

    public Point2dImpl() {
    }

    public Point2dImpl(Coordinate coord) {
        this.x = coord.getOrdinate(0).floatValue();
        this.y = coord.getOrdinate(1).floatValue();
    }

    public Point2dImpl(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public void copyFrom(Point2d p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Point2dImpl clone() {
        Point2dImpl clone;
        try {
            clone = (Point2dImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return clone;
    }

    @Override
    public Float getOrdinate(int dimension) {
        if (dimension == 0) {
            return Float.valueOf(this.x);
        }
        return Float.valueOf(this.y);
    }

    @Override
    public int getDimensions() {
        return 2;
    }

    @Override
    public void translate(float x, float y) {
        this.x += x;
        this.y += y;
    }

    @Override
    public void translate(Point2d v) {
        this.x += v.getX();
        this.y += v.getY();
    }

    @Override
    public Point2dImpl transform(Matrix transform) {
        if (transform.getRowDimension() == 3) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY() + (float)transform.get(0, 2);
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY() + (float)transform.get(1, 2);
            float zt = (float)transform.get(2, 0) * this.getX() + (float)transform.get(2, 1) * this.getY() + (float)transform.get(2, 2);
            return new Point2dImpl(xt /= zt, yt /= zt);
        }
        if (transform.getRowDimension() == 2 && transform.getColumnDimension() == 2) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY();
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY();
            return new Point2dImpl(xt, yt);
        }
        if (transform.getRowDimension() == 2 && transform.getColumnDimension() == 3) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY() + (float)transform.get(0, 2);
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY() + (float)transform.get(1, 2);
            return new Point2dImpl(xt, yt);
        }
        throw new IllegalArgumentException("Transform matrix has unexpected size");
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point2d)) {
            return false;
        }
        Point2d p = (Point2d)o;
        return p.getX() == this.x && p.getY() == this.y;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Point2d minus(Point2d a) {
        return new Point2dImpl(this.x - a.getX(), this.y - a.getY());
    }

    public void readASCII(Scanner in) throws IOException {
        this.x = in.nextFloat();
        this.y = in.nextFloat();
    }

    public String asciiHeader() {
        return "Point2d";
    }

    public void readBinary(DataInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
    }

    public byte[] binaryHeader() {
        return "PT2D".getBytes();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%f %f", Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
    }

    @Override
    public Point2dImpl copy() {
        return this.clone();
    }

    public static Point2d createRandomPoint() {
        return new Point2dImpl((float)Math.random(), (float)Math.random());
    }

    public static Point2d createRandomPoint(Random rng) {
        return new Point2dImpl(rng.nextFloat(), rng.nextFloat());
    }

    public static Point2d fromDoubleArray(double[] calculateCentroid) {
        return new Point2dImpl((float)calculateCentroid[0], (float)calculateCentroid[1]);
    }
}

