/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.local.SpatialLocation;
import org.openimaj.math.geometry.point.ScaleSpacePoint;

public class ScaleSpaceLocation
extends SpatialLocation
implements ScaleSpacePoint,
Cloneable {
    private static final long serialVersionUID = 1L;
    public float scale;

    public ScaleSpaceLocation() {
        super(0.0f, 0.0f);
    }

    public ScaleSpaceLocation(float x, float y, float scale) {
        super(x, y);
        this.scale = scale;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.scale);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%4.2f %4.2f %4.2f", Float.valueOf(this.y), Float.valueOf(this.x), Float.valueOf(this.scale));
        out.println();
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.scale = in.readFloat();
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.y = Float.parseFloat(in.next());
        this.x = Float.parseFloat(in.next());
        this.scale = Float.parseFloat(in.next());
    }

    @Override
    public byte[] binaryHeader() {
        return "".getBytes();
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public Float getOrdinate(int dimension) {
        float[] pos = new float[]{this.x, this.y, this.scale};
        return Float.valueOf(pos[dimension]);
    }

    @Override
    public int getDimensions() {
        return 3;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public ScaleSpaceLocation clone() {
        ScaleSpaceLocation l = (ScaleSpaceLocation)super.clone();
        l.scale = this.scale;
        return l;
    }
}

